/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageOptions;
import com.intellij.coverage.CoverageOptionsProvider;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CoverageOptionsConfigurable
implements SearchableConfigurable {
    private CoverageOptionsPanel myPanel;
    private final CoverageOptionsProvider myManager;
    private final Project myProject;

    public CoverageOptionsConfigurable(CoverageOptionsProvider manager, Project project) {
        this.myManager = manager;
        this.myProject = project;
    }

    @NotNull
    public String getId() {
        if ("coverage" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/CoverageOptionsConfigurable", "getId"));
        }
        return "coverage";
    }

    @Nls
    public String getDisplayName() {
        return "Coverage";
    }

    public String getHelpTopic() {
        return "reference.project.settings.coverage";
    }

    public JComponent createComponent() {
        this.myPanel = new CoverageOptionsPanel();
        List<JComponent> extensionPanels = this.collectExtensionOptionsComponents();
        if (extensionPanels.size() > 0) {
            return this.createCompositePanel(extensionPanels);
        }
        return this.myPanel.myWholePanel;
    }

    private List<JComponent> collectExtensionOptionsComponents() {
        ArrayList additionalPanels = ContainerUtil.newArrayList();
        for (CoverageOptions coverageOptions : this.getExtensions()) {
            additionalPanels.add(coverageOptions.getComponent());
        }
        return additionalPanels;
    }

    private JComponent createCompositePanel(List<JComponent> additionalPanels) {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.gridx = 0;
        c.gridy = -1;
        c.weightx = 1.0;
        c.fill = 2;
        panel.add((Component)this.myPanel.myWholePanel, c);
        for (JComponent p : additionalPanels) {
            panel.add((Component)p, c);
        }
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel.add((Component)Box.createVerticalBox(), c);
        return panel;
    }

    @NotNull
    private CoverageOptions[] getExtensions() {
        CoverageOptions[] coverageOptionsArray = (CoverageOptions[])Extensions.getExtensions(CoverageOptions.EP_NAME, (AreaInstance)this.myProject);
        if (coverageOptionsArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/CoverageOptionsConfigurable", "getExtensions"));
        }
        return coverageOptionsArray;
    }

    public boolean isModified() {
        if (this.myManager.getOptionToReplace() != this.getSelectedValue()) {
            return true;
        }
        if (this.myManager.activateViewOnRun() != this.myPanel.myActivateCoverageViewCB.isSelected()) {
            return true;
        }
        for (CoverageOptions coverageOptions : this.getExtensions()) {
            if (!coverageOptions.isModified()) continue;
            return true;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        this.myManager.setOptionsToReplace(this.getSelectedValue());
        this.myManager.setActivateViewOnRun(this.myPanel.myActivateCoverageViewCB.isSelected());
        for (CoverageOptions coverageOptions : this.getExtensions()) {
            coverageOptions.apply();
        }
    }

    private int getSelectedValue() {
        if (this.myPanel.myReplaceRB.isSelected()) {
            return 0;
        }
        if (this.myPanel.myAddRB.isSelected()) {
            return 1;
        }
        if (this.myPanel.myDoNotApplyRB.isSelected()) {
            return 2;
        }
        return 3;
    }

    public void reset() {
        int addOrReplace = this.myManager.getOptionToReplace();
        switch (addOrReplace) {
            case 0: {
                this.myPanel.myReplaceRB.setSelected(true);
                break;
            }
            case 1: {
                this.myPanel.myAddRB.setSelected(true);
                break;
            }
            case 2: {
                this.myPanel.myDoNotApplyRB.setSelected(true);
                break;
            }
            default: {
                this.myPanel.myShowOptionsRB.setSelected(true);
            }
        }
        this.myPanel.myActivateCoverageViewCB.setSelected(this.myManager.activateViewOnRun());
        for (CoverageOptions coverageOptions : this.getExtensions()) {
            coverageOptions.reset();
        }
    }

    public void disposeUIResources() {
        this.myPanel = null;
        for (CoverageOptions coverageOptions : this.getExtensions()) {
            coverageOptions.disposeUIResources();
        }
    }

    private static class CoverageOptionsPanel {
        private JRadioButton myShowOptionsRB;
        private JRadioButton myReplaceRB;
        private JRadioButton myAddRB;
        private JRadioButton myDoNotApplyRB;
        private JPanel myWholePanel;
        private JCheckBox myActivateCoverageViewCB;

        private CoverageOptionsPanel() {
            this.$$$setupUI$$$();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JRadioButton jRadioButton;
            JRadioButton jRadioButton2;
            JRadioButton jRadioButton3;
            JRadioButton jRadioButton4;
            JPanel jPanel;
            this.myWholePanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
            jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"When new coverage is gathered", (int)0, (int)0, null, null));
            this.myShowOptionsRB = jRadioButton4 = new JRadioButton();
            jRadioButton4.setText("Show options before applying coverage to the editor");
            jRadioButton4.setMnemonic('S');
            jRadioButton4.setDisplayedMnemonicIndex(0);
            jPanel2.add((Component)jRadioButton4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myReplaceRB = jRadioButton3 = new JRadioButton();
            jRadioButton3.setText("Replace active suites with the new one");
            jRadioButton3.setMnemonic('R');
            jRadioButton3.setDisplayedMnemonicIndex(0);
            jPanel2.add((Component)jRadioButton3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myAddRB = jRadioButton2 = new JRadioButton();
            jRadioButton2.setText("Add to the active suites");
            jRadioButton2.setMnemonic('D');
            jRadioButton2.setDisplayedMnemonicIndex(1);
            jPanel2.add((Component)jRadioButton2, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myDoNotApplyRB = jRadioButton = new JRadioButton();
            jRadioButton.setText("Do not apply collected coverage");
            jRadioButton.setMnemonic('N');
            jRadioButton.setDisplayedMnemonicIndex(3);
            jPanel2.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myActivateCoverageViewCB = jCheckBox = new JCheckBox();
            jCheckBox.setMargin(new Insets(8, 3, 2, 3));
            jCheckBox.setText("Activate Coverage View ");
            jCheckBox.setMnemonic('V');
            jCheckBox.setDisplayedMnemonicIndex(18);
            jPanel2.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(jRadioButton4);
            buttonGroup.add(jRadioButton3);
            buttonGroup.add(jRadioButton2);
            buttonGroup.add(jRadioButton);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myWholePanel;
        }
    }
}

