/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.tapestry.core.TapestryProject;
import com.intellij.tapestry.intellij.core.java.IntellijJavaTypeCreator;
import com.intellij.tapestry.intellij.core.java.IntellijJavaTypeFinder;
import com.intellij.tapestry.intellij.core.resource.IntellijResourceFinder;
import com.intellij.tapestry.lang.TmlFileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="Loomy")
public class TapestryModuleSupportLoader
implements PersistentStateComponent<ModuleConfiguration> {
    private final TapestryProject _tapestryProject;
    private ModuleConfiguration _configuration = new ModuleConfiguration();

    public TapestryModuleSupportLoader(Module module) {
        this._tapestryProject = new TapestryProject(module, new IntellijResourceFinder(module), new IntellijJavaTypeFinder(module), new IntellijJavaTypeCreator(module));
    }

    public static TapestryModuleSupportLoader getInstance(Module module) {
        return (TapestryModuleSupportLoader)ModuleServiceManager.getService((Module)module, TapestryModuleSupportLoader.class);
    }

    @Nullable
    public static TapestryModuleSupportLoader getInstance(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/tapestry/intellij/TapestryModuleSupportLoader", "getInstance"));
        }
        PsiFile file = element.getContainingFile();
        if (file == null || !(file.getFileType() instanceof TmlFileType)) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        return module != null ? TapestryModuleSupportLoader.getInstance(module) : null;
    }

    @Nullable
    public static TapestryProject getTapestryProject(@Nullable Module module) {
        return module == null || module.isDisposed() ? null : TapestryModuleSupportLoader.getInstance(module).getTapestryProject();
    }

    @Nullable
    public static TapestryProject getTapestryProject(@NotNull XmlElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/tapestry/intellij/TapestryModuleSupportLoader", "getTapestryProject"));
        }
        TapestryModuleSupportLoader instance = TapestryModuleSupportLoader.getInstance((PsiElement)element);
        return instance == null ? null : instance.getTapestryProject();
    }

    public TapestryProject getTapestryProject() {
        return this._tapestryProject;
    }

    public ModuleConfiguration getState() {
        return this._configuration;
    }

    public void loadState(ModuleConfiguration state) {
        this._configuration = state;
    }

    public static class ModuleConfiguration {
        private String _newPagesTemplatesSourceDirectory;
        private String _newPagesClassesSourceDirectory;
        private String _newComponentsTemplatesSourceDirectory;
        private String _newComponentsClassesSourceDirectory;
        private String _newMixinsClassesSourceDirectory;

        public String getNewPagesTemplatesSourceDirectory() {
            return this._newPagesTemplatesSourceDirectory;
        }

        public void setNewPagesTemplatesSourceDirectory(String newPagesTemplatesSourceDirectory) {
            this._newPagesTemplatesSourceDirectory = newPagesTemplatesSourceDirectory;
        }

        public String getNewPagesClassesSourceDirectory() {
            return this._newPagesClassesSourceDirectory;
        }

        public void setNewPagesClassesSourceDirectory(String newPagesClassesSourceDirectory) {
            this._newPagesClassesSourceDirectory = newPagesClassesSourceDirectory;
        }

        public String getNewComponentsTemplatesSourceDirectory() {
            return this._newComponentsTemplatesSourceDirectory;
        }

        public void setNewComponentsTemplatesSourceDirectory(String newComponentsTemplatesSourceDirectory) {
            this._newComponentsTemplatesSourceDirectory = newComponentsTemplatesSourceDirectory;
        }

        public String getNewComponentsClassesSourceDirectory() {
            return this._newComponentsClassesSourceDirectory;
        }

        public void setNewComponentsClassesSourceDirectory(String newComponentsClassesSourceDirectory) {
            this._newComponentsClassesSourceDirectory = newComponentsClassesSourceDirectory;
        }

        public String getNewMixinsClassesSourceDirectory() {
            return this._newMixinsClassesSourceDirectory;
        }

        public void setNewMixinsClassesSourceDirectory(String newMixinsClassesSourceDirectory) {
            this._newMixinsClassesSourceDirectory = newMixinsClassesSourceDirectory;
        }
    }
}

