/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.view;

import com.intellij.ide.IdeView;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.tapestry.intellij.view.TapestryProjectViewPane;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TapestryIdeView
implements IdeView {
    private final TapestryProjectViewPane _viewPane;

    protected TapestryIdeView(TapestryProjectViewPane viewPane) {
        this._viewPane = viewPane;
    }

    @NotNull
    public PsiDirectory[] getDirectories() {
        ArrayList directories = new ArrayList();
        ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance((Module)((Module)this._viewPane.getData(DataKeys.MODULE.getName()))).getFileIndex();
        moduleFileIndex.iterateContent(virtualfile -> {
            if (virtualfile.isDirectory() && moduleFileIndex.isInSourceContent(virtualfile)) {
                directories.add(PsiManager.getInstance((Project)this._viewPane.getProject()).findDirectory(virtualfile));
            }
            return true;
        });
        PsiDirectory[] psiDirectoryArray = directories.toArray(PsiDirectory.EMPTY_ARRAY);
        if (psiDirectoryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/view/TapestryIdeView", "getDirectories"));
        }
        return psiDirectoryArray;
    }

    @Nullable
    public PsiDirectory getOrChooseDirectory() {
        Object element = this._viewPane.getSelectedDescriptor().getElement();
        if (element instanceof PsiDirectory) {
            return (PsiDirectory)element;
        }
        if (element instanceof PsiFile) {
            return ((PsiFile)element).getContainingDirectory();
        }
        return null;
    }
}

