/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssPageRule;
import com.intellij.psi.css.CssPseudoPage;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.impl.AtRulePresentation;
import com.intellij.psi.css.impl.CssAtRuleImpl;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssPageRuleImpl
extends CssAtRuleImpl
implements CssPageRule {
    public CssPageRuleImpl() {
        super(CssContextType.PAGE, CssElementTypes.CSS_PAGE);
    }

    @Override
    @NotNull
    public String getName() {
        PsiElement nameIdentifier = this.getNameIdentifier();
        String string = nameIdentifier != null ? nameIdentifier.getText() : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssPageRuleImpl", "getName"));
        }
        return string;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this.findPsiChildByType(CssElementTypes.CSS_IDENT);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/CssPageRuleImpl", "setName"));
        }
        PsiElement token = this.getNameIdentifier();
        if (token != null) {
            CssPsiUtil.replaceToken((PsiElement)token, (String)name);
        }
        return this;
    }

    public int getTextOffset() {
        PsiElement nameIdentifier = this.getNameIdentifier();
        return nameIdentifier != null ? nameIdentifier.getTextOffset() : super.getTextOffset();
    }

    @NotNull
    public CssPseudoPage[] getPseudoPages() {
        CssPseudoPage[] cssPseudoPageArray = (CssPseudoPage[])this.getChildrenAsPsiElements((IElementType)CssElementTypes.CSS_PSEUDO_PAGE, CssPseudoPage.ARRAY_FACTORY);
        if (cssPseudoPageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssPageRuleImpl", "getPseudoPages"));
        }
        return cssPseudoPageArray;
    }

    @Override
    public ItemPresentation getPresentation() {
        String join = StringUtil.join((Object[])this.getPseudoPages(), page -> page.getName(), (String)":");
        return new AtRulePresentation(this, "page " + this.getName() + (!join.isEmpty() ? ":" + join : ""));
    }

    public int getLineNumber() {
        PsiUtilCore.ensureValid((PsiElement)this);
        Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(this.getContainingFile());
        return document != null ? document.getLineNumber(this.getTextOffset()) + 1 : -1;
    }
}

