/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssAttribute;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssIdSelector;
import com.intellij.psi.css.CssPseudoClass;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.Specificity;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.stubs.CssSelectorStub;
import com.intellij.psi.css.impl.stubs.base.CssStubElement;
import com.intellij.psi.css.impl.stubs.base.CssStubElementType;
import com.intellij.psi.css.resolve.CssResolver;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssSelectorImpl
extends CssStubElement<CssSelectorStub>
implements CssSelector {
    private static final TokenSet ELEMENT_FILTER = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_SIMPLE_SELECTOR, CssElementTypes.CSS_GT, CssElementTypes.CSS_KEYFRAMES_SELECTOR, CssElementTypes.CSS_PLUS, CssElementTypes.CSS_TILDA});

    public CssSelectorImpl(@NotNull CssSelectorStub stub, @NotNull CssStubElementType nodeType) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/css/impl/CssSelectorImpl", "<init>"));
        }
        if (nodeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeType", "com/intellij/psi/css/impl/CssSelectorImpl", "<init>"));
        }
        super(stub, nodeType);
    }

    public CssSelectorImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/css/impl/CssSelectorImpl", "<init>"));
        }
        super(node);
    }

    public PsiElement[] getElements() {
        return this.getStubOrPsiChildren(ELEMENT_FILTER, ARRAY_FACTORY);
    }

    @NotNull
    public String getPresentableText() {
        StringBuilder result = new StringBuilder();
        CssSelector.Combinator[] combinators = this.getCombinators();
        CssSimpleSelector[] selectors = this.getSimpleSelectors();
        for (int i = 0; i < combinators.length; ++i) {
            CssSelector.Combinator combinator = combinators[i];
            if (combinator != CssSelector.Combinator.DESCENDANT) {
                result.append(combinator.getPresentation());
                result.append(' ');
            }
            if (selectors.length <= i) continue;
            result.append(selectors[i].getPresentableText()).append(' ');
        }
        String string = result.toString().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssSelectorImpl", "getPresentableText"));
        }
        return string;
    }

    @NotNull
    public CssSelector.Combinator[] getCombinators() {
        CssSelectorStub stub = (CssSelectorStub)this.getStub();
        if (stub != null) {
            CssSelector.Combinator[] combinatorArray = stub.getCombinators();
            if (combinatorArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssSelectorImpl", "getCombinators"));
            }
            return combinatorArray;
        }
        CssSelector.Combinator[] combinatorArray = (CssSelector.Combinator[])CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            LinkedList result = ContainerUtil.newLinkedList();
            for (CssSimpleSelector selector : this.getSimpleSelectors()) {
                CssSelector.Combinator prevCombinator = CssSelector.Combinator.DESCENDANT;
                for (PsiElement prevSibling = selector.getPrevSibling(); prevSibling != null && !(prevSibling instanceof CssSimpleSelector); prevSibling = prevSibling.getPrevSibling()) {
                    CssSelector.Combinator combinator = CssSelectorImpl.combinatorFromElementType(prevSibling.getNode().getElementType());
                    if (combinator == null) continue;
                    prevCombinator = combinator;
                    break;
                }
                result.add(prevCombinator);
            }
            return CachedValueProvider.Result.create((Object)result.toArray(new CssSelector.Combinator[result.size()]), (Object[])new Object[]{this});
        });
        if (combinatorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssSelectorImpl", "getCombinators"));
        }
        return combinatorArray;
    }

    @NotNull
    public CssSimpleSelector[] getSimpleSelectors() {
        CssSimpleSelector[] cssSimpleSelectorArray = (CssSimpleSelector[])this.getStubOrPsiChildren(TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_SIMPLE_SELECTOR, CssElementTypes.CSS_KEYFRAMES_SELECTOR}), (PsiElement[])CssSimpleSelector.EMPTY_ARRAY);
        if (cssSimpleSelectorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssSelectorImpl", "getSimpleSelectors"));
        }
        return cssSimpleSelectorArray;
    }

    public Specificity getSpecificity() {
        CssSimpleSelector[] simpleSelectors;
        int idAttributesNumber = 0;
        int attributesNumber = 0;
        int elementNamesNumber = 0;
        for (CssSimpleSelector simpleSelector : simpleSelectors = this.getSimpleSelectors()) {
            CssSelectorSuffix[] selectorSuffixes;
            for (CssSelectorSuffix suffix : selectorSuffixes = simpleSelector.getSelectorSuffixes()) {
                if (suffix instanceof CssClass || suffix instanceof CssAttribute || suffix instanceof CssPseudoClass) {
                    ++attributesNumber;
                    continue;
                }
                if (!(suffix instanceof CssIdSelector)) continue;
                ++idAttributesNumber;
            }
            if (simpleSelector.isUniversalSelector()) continue;
            ++elementNamesNumber;
        }
        return new Specificity(idAttributesNumber, attributesNumber, elementNamesNumber);
    }

    public boolean processAmpersandEvaluatedSelectors(@NotNull CssSelector originalSelector, @Nullable Language language, @NotNull Processor<CssSelector> processor) {
        if (originalSelector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalSelector", "com/intellij/psi/css/impl/CssSelectorImpl", "processAmpersandEvaluatedSelectors"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/css/impl/CssSelectorImpl", "processAmpersandEvaluatedSelectors"));
        }
        CssRuleset parentRuleset = (CssRuleset)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)originalSelector.getRuleset(), CssRuleset.class);
        if (parentRuleset != null) {
            for (CssSelector selector : parentRuleset.getSelectors()) {
                ProgressIndicatorProvider.checkCanceled();
                String newText = StringUtil.replace((String)this.getPresentableText(), (String)"&", (String)selector.getPresentableText());
                CssRuleset ruleset = null;
                try {
                    ruleset = CssElementFactory.getInstance((Project)this.getProject()).createRuleset(newText, CssDeclaration.EMPTY_ARRAY, language);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                CssSelector newSelector = (CssSelector)PsiTreeUtil.findChildOfType(ruleset, CssSelector.class);
                if (newSelector == null) {
                    Logger.getInstance(CssSelectorImpl.class).error("Cannot create ampersand selector for parent selector '" + selector.getText() + "' and child selector '" + this.getText() + "'");
                    return true;
                }
                if (!(newSelector.isAmpersandSelector() ? !newSelector.processAmpersandEvaluatedSelectors(selector, language, processor) : !processor.process((Object)newSelector))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isMatch(XmlTag tag, CssResolver resolver, Map<XmlTag, CssSimpleSelector> mapping) {
        if (this.isAmpersandSelector()) {
            return !this.processAmpersandEvaluatedSelectors(this, CssPsiUtil.getStylesheetLanguage((PsiElement)this), (Processor<CssSelector>)((Processor)selector -> !CssSelectorImpl.isMatchInner(selector, tag, resolver, mapping)));
        }
        return CssSelectorImpl.isMatchInner(this, tag, resolver, mapping);
    }

    private static boolean isMatchInner(@NotNull CssSelector selector, XmlTag tag, CssResolver resolver, Map<XmlTag, CssSimpleSelector> mapping) {
        int last;
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/psi/css/impl/CssSelectorImpl", "isMatchInner"));
        }
        boolean match = true;
        PsiElement[] elements = selector.getElements();
        XmlTag currentTag = tag;
        boolean strictMatch = true;
        boolean adjacent = false;
        block0: for (int i = last = elements.length - 1; i >= 0; --i) {
            PsiElement element = elements[i];
            if (element instanceof CssSimpleSelector) {
                CssSimpleSelector simpleSelector = (CssSimpleSelector)element;
                do {
                    if (i < last) {
                        PsiElement candidate;
                        if (adjacent) {
                            adjacent = false;
                            strictMatch = true;
                            candidate = currentTag;
                            while ((candidate = candidate.getPrevSibling()) != null && !(candidate instanceof XmlTag)) {
                            }
                        } else {
                            candidate = currentTag.getParent();
                            if (!(candidate instanceof XmlTag)) {
                                candidate = null;
                            }
                        }
                        if ((currentTag = (XmlTag)candidate) == null) {
                            match = false;
                            break block0;
                        }
                    }
                    match = simpleSelector.isMatch(currentTag, resolver);
                    if (strictMatch && !match) break block0;
                    strictMatch = false;
                } while (!match);
                if (mapping == null) continue;
                mapping.put(currentTag, simpleSelector);
                continue;
            }
            if (element instanceof LeafElement) {
                IElementType tokenType = ((LeafElement)element).getElementType();
                if (tokenType == CssElementTypes.CSS_GT) {
                    strictMatch = true;
                    continue;
                }
                if (tokenType == CssElementTypes.CSS_PLUS) {
                    adjacent = true;
                    continue;
                }
                if (tokenType == CssElementTypes.CSS_TILDA) continue;
                throw new RuntimeException(String.valueOf(tokenType));
            }
            throw new RuntimeException(String.valueOf(element.getClass()));
        }
        return match;
    }

    @Nullable
    public CssRuleset getRuleset() {
        return (CssRuleset)this.getStubOrPsiParentOfType(CssRuleset.class);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/css/impl/CssSelectorImpl", "accept"));
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitCssSelector((CssSelector)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public boolean isAmpersandSelector() {
        CssSelectorStub stub = (CssSelectorStub)this.getStub();
        if (stub != null) {
            return stub.isAmpersandSelector();
        }
        return this.textContains('&');
    }

    private static CssSelector.Combinator combinatorFromElementType(@NotNull IElementType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/css/impl/CssSelectorImpl", "combinatorFromElementType"));
        }
        if (type == CssElementTypes.CSS_GT) {
            return CssSelector.Combinator.CHILD;
        }
        if (type == CssElementTypes.CSS_PLUS) {
            return CssSelector.Combinator.SIBLING;
        }
        if (type == CssElementTypes.CSS_TILDA) {
            return CssSelector.Combinator.FOLLOWING_SIBLING;
        }
        return null;
    }
}

