/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssValueDeclaration;
import com.intellij.psi.css.impl.CssElementImpl;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssValueDeclarationImpl
extends CssElementImpl
implements CssValueDeclaration {
    public CssValueDeclarationImpl() {
        super(CssElementTypes.CSS_VALUE_DECLARATION);
    }

    @Nullable
    public String getName() {
        PsiElement identifier = this.getNameIdentifier();
        return identifier == null ? null : identifier.getText();
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        PsiElement child = this.getFirstChild();
        if (child.getNode().getElementType() == CssElementTypes.CSS_IDENT) {
            return child;
        }
        return null;
    }

    public int getTextOffset() {
        PsiElement identifier = this.getNameIdentifier();
        return identifier != null ? identifier.getTextOffset() : super.getTextOffset();
    }

    public int getLineNumber() {
        PsiUtilCore.ensureValid((PsiElement)this);
        Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(this.getContainingFile());
        return document != null ? document.getLineNumber(this.getTextOffset()) + 1 : -1;
    }

    @NotNull
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/CssValueDeclarationImpl", "setName"));
        }
        PsiElement identifier = this.getNameIdentifier();
        if (identifier != null) {
            CssPsiUtil.replaceToken((PsiElement)identifier, (String)name);
        }
        CssValueDeclarationImpl cssValueDeclarationImpl = this;
        if (cssValueDeclarationImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssValueDeclarationImpl", "setName"));
        }
        return cssValueDeclarationImpl;
    }

    @Nullable
    public String getValueValueText() {
        PsiElement[] elements = this.getChildrenAsPsiElements(CssElementTypes.CSS_VALUE_VALUE, ARRAY_FACTORY);
        return elements.length == 0 ? null : elements[0].getText();
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/css/impl/CssValueDeclarationImpl", "accept"));
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitValueDeclaration((CssValueDeclaration)this);
        } else {
            super.accept(visitor);
        }
    }
}

