/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.index;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.css.index.CssIndex;
import com.intellij.psi.css.util.CssResolveUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CssTemplateSelectorsIndex
extends FileBasedIndexExtension<String, SelectorInfo> {
    public static final ID<String, SelectorInfo> KEY = ID.create((String)"css.template.selectors");
    public static final DataExternalizer<SelectorInfo> DATA_EXTERNALIZER = new DataExternalizer<SelectorInfo>(){

        public void save(@NotNull DataOutput out, SelectorInfo value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/psi/css/index/CssTemplateSelectorsIndex$1", "save"));
            }
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value.offset);
            IOUtil.writeUTF((DataOutput)out, (String)value.name);
            IOUtil.writeUTF((DataOutput)out, (String)value.tagName);
        }

        public SelectorInfo read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/psi/css/index/CssTemplateSelectorsIndex$1", "read"));
            }
            int offset = DataInputOutputUtil.readINT((DataInput)in);
            String name = IOUtil.readUTF((DataInput)in);
            String tagName = IOUtil.readUTF((DataInput)in);
            return new SelectorInfo(name, tagName, offset);
        }
    };
    private final DataIndexer<String, SelectorInfo, FileContent> myDataIndexer = new MyDataIndexer();

    @NotNull
    public ID<String, SelectorInfo> getName() {
        ID<String, SelectorInfo> iD = KEY;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/index/CssTemplateSelectorsIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, SelectorInfo, FileContent> getIndexer() {
        DataIndexer<String, SelectorInfo, FileContent> dataIndexer = this.myDataIndexer;
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/index/CssTemplateSelectorsIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/index/CssTemplateSelectorsIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<SelectorInfo> getValueExternalizer() {
        DataExternalizer<SelectorInfo> dataExternalizer = DATA_EXTERNALIZER;
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/index/CssTemplateSelectorsIndex", "getValueExternalizer"));
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter((FileType[])Holder.supportedFileTypes){

            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/index/CssTemplateSelectorsIndex$2", "acceptInput"));
                }
                return super.acceptInput(file) && !(file.getFileSystem() instanceof JarFileSystem);
            }
        };
        if (defaultFileTypeSpecificInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/index/CssTemplateSelectorsIndex", "getInputFilter"));
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        int version = 29;
        for (LanguageFileType fileType : Holder.supportedFileTypes) {
            version += fileType.getName().hashCode();
        }
        return version;
    }

    public static class SelectorInfo {
        @NotNull
        public final String name;
        @NotNull
        public final String tagName;
        public final int offset;

        public SelectorInfo(@NotNull String name, @NotNull String tagName, int offset) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/index/CssTemplateSelectorsIndex$SelectorInfo", "<init>"));
            }
            if (tagName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/intellij/psi/css/index/CssTemplateSelectorsIndex$SelectorInfo", "<init>"));
            }
            this.name = name;
            this.offset = offset;
            this.tagName = tagName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SelectorInfo info = (SelectorInfo)o;
            if (this.offset != info.offset) {
                return false;
            }
            if (!this.name.equals(info.name)) {
                return false;
            }
            return this.tagName.equals(info.tagName);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.tagName.hashCode();
            result = 31 * result + this.offset;
            return result;
        }
    }

    private static class MyDataIndexer
    implements DataIndexer<String, SelectorInfo, FileContent> {
        private MyDataIndexer() {
        }

        @NotNull
        public Map<String, SelectorInfo> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/psi/css/index/CssTemplateSelectorsIndex$MyDataIndexer", "map"));
            }
            THashMap result = new THashMap();
            FileViewProvider viewProvider = inputData.getPsiFile().getViewProvider();
            PsiFile psi = viewProvider.getPsi((Language)HTMLLanguage.INSTANCE);
            if (psi == null) {
                psi = viewProvider.getPsi((Language)XHTMLLanguage.INSTANCE);
            }
            if (psi != null) {
                psi.accept((PsiElementVisitor)new XmlRecursiveElementWalkingVisitor((Map)result){
                    final /* synthetic */ Map val$result;
                    {
                        this.val$result = map;
                    }

                    public void visitXmlAttribute(XmlAttribute attribute) {
                        String value;
                        XmlAttributeValue valueElement;
                        XmlTag tag = attribute.getParent();
                        String tagName = tag != null ? tag.getName() : "";
                        String attributeName = attribute.getName();
                        if (Comparing.strEqual((String)"class", (String)attributeName, (boolean)false)) {
                            String value2;
                            XmlAttributeValue valueElement2 = attribute.getValueElement();
                            if (valueElement2 != null && (value2 = attribute.getValue()) != null) {
                                int startOffset = valueElement2.getTextRange().getStartOffset() + ElementManipulators.getValueTextRange((PsiElement)valueElement2).getStartOffset();
                                PairConsumer consumer = (name, range) -> {
                                    String className = range.substring(value2);
                                    if (!className.isEmpty()) {
                                        int offset = startOffset + range.getStartOffset();
                                        SelectorInfo selectorInfo = new SelectorInfo("." + className, tagName, offset);
                                        this.val$result.put(selectorInfo.name, selectorInfo);
                                    }
                                };
                                CssResolveUtil.consumeClassNames(valueElement2.getValue(), (PsiElement)valueElement2, (PairConsumer<String, TextRange>)consumer);
                            }
                        } else if (Comparing.strEqual((String)"id", (String)attributeName, (boolean)false) && (valueElement = attribute.getValueElement()) != null && StringUtil.isNotEmpty((String)(value = attribute.getValue()))) {
                            int offset = valueElement.getTextRange().getStartOffset() + ElementManipulators.getValueTextRange((PsiElement)valueElement).getStartOffset();
                            SelectorInfo selectorInfo = new SelectorInfo("#" + value, tagName, offset);
                            this.val$result.put(selectorInfo.name, selectorInfo);
                        }
                        super.visitXmlAttribute(attribute);
                    }
                });
            }
            THashMap tHashMap = result;
            if (tHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/index/CssTemplateSelectorsIndex$MyDataIndexer", "map"));
            }
            return tHashMap;
        }
    }

    private static class Holder {
        private static final LanguageFileType[] supportedFileTypes;

        private Holder() {
        }

        static {
            ArrayList types = ContainerUtil.newArrayList((Object[])new LanguageFileType[]{StdFileTypes.HTML, StdFileTypes.XHTML});
            for (FileType fileType : FileTypeRegistry.getInstance().getRegisteredFileTypes()) {
                if (!CssIndex.isSupportedTemplateLanguage(fileType)) continue;
                types.add((LanguageFileType)fileType);
            }
            supportedFileTypes = types.toArray(new LanguageFileType[types.size()]);
        }
    }
}

