/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.BindingTarget;
import android.databinding.tool.expr.BuiltInVariableExpr;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.writer.LayoutBinderWriterKt;

public class ViewFieldExpr
extends BuiltInVariableExpr {
    private final BindingTarget mBindingTarget;

    ViewFieldExpr(BindingTarget bindingTarget) {
        super(LayoutBinderWriterKt.getFieldName(bindingTarget), bindingTarget.getInterfaceType(), LayoutBinderWriterKt.getFieldName(bindingTarget));
        this.mBindingTarget = bindingTarget;
    }

    @Override
    public String getInvertibleError() {
        return "View fields may not be the target of two-way binding";
    }

    public BindingTarget getBindingTarget() {
        return this.mBindingTarget;
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        ModelClass type = modelAnalyzer.findClass(this.mBindingTarget.getInterfaceType(), null);
        if (type == null) {
            return modelAnalyzer.findClass("android.databinding.ViewDataBinding", null);
        }
        return type;
    }

    @Override
    public Expr cloneToModel(ExprModel model) {
        return model.viewFieldExpr(this.mBindingTarget);
    }
}

