/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.steps;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.lang.Language;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.java.stubs.index.JavaFullClassNameIndex;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import cucumber.runtime.snippets.CamelCaseConcatenator;
import cucumber.runtime.snippets.Concatenator;
import cucumber.runtime.snippets.FunctionNameGenerator;
import cucumber.runtime.snippets.Snippet;
import cucumber.runtime.snippets.SnippetGenerator;
import gherkin.formatter.model.Step;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.java.CucumberJavaUtil;
import org.jetbrains.plugins.cucumber.java.steps.Java8Snippet;
import org.jetbrains.plugins.cucumber.java.steps.JavaStepDefinitionCreator;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;

public class Java8StepDefinitionCreator
extends JavaStepDefinitionCreator {
    public static final String CUCUMBER_API_JAVA8_EN = "cucumber.api.java8.En";

    @Override
    @NotNull
    public PsiFile createStepDefinitionContainer(@NotNull PsiDirectory dir, @NotNull String name) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/plugins/cucumber/java/steps/Java8StepDefinitionCreator", "createStepDefinitionContainer"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/cucumber/java/steps/Java8StepDefinitionCreator", "createStepDefinitionContainer"));
        }
        PsiFile result = super.createStepDefinitionContainer(dir, name);
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)dir.getProject()).getFileIndex();
        Module module = fileIndex.getModuleForFile(result.getVirtualFile());
        assert (module != null);
        GlobalSearchScope dependenciesScope = module.getModuleWithDependenciesAndLibrariesScope(true);
        Collection stepDefContainerInterfaces = JavaFullClassNameIndex.getInstance().get(Integer.valueOf(CUCUMBER_API_JAVA8_EN.hashCode()), module.getProject(), dependenciesScope);
        if (stepDefContainerInterfaces.size() > 0) {
            PsiReferenceList implementsList;
            PsiClass stepDefContainerInterface = (PsiClass)stepDefContainerInterfaces.iterator().next();
            PsiClass createPsiClass = (PsiClass)PsiTreeUtil.getChildOfType((PsiElement)result, PsiClass.class);
            assert (createPsiClass != null);
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)dir.getProject()).getElementFactory();
            PsiJavaCodeReferenceElement ref = elementFactory.createClassReferenceElement(stepDefContainerInterface);
            if (stepDefContainerInterface.isInterface() && (implementsList = createPsiClass.getImplementsList()) != null) {
                WriteAction.run(() -> implementsList.add((PsiElement)ref));
            }
        }
        PsiFile psiFile = result;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/java/steps/Java8StepDefinitionCreator", "createStepDefinitionContainer"));
        }
        return psiFile;
    }

    @Override
    @NotNull
    public String getStepDefinitionFilePath(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/cucumber/java/steps/Java8StepDefinitionCreator", "getStepDefinitionFilePath"));
        }
        String string = super.getStepDefinitionFilePath(file) + " (Java 8 style)";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/java/steps/Java8StepDefinitionCreator", "getStepDefinitionFilePath"));
        }
        return string;
    }

    private static PsiMethod getConstructor(PsiClass clazz) {
        if (clazz.getConstructors().length == 0) {
            JVMElementFactory factory = JVMElementFactories.requireFactory((Language)clazz.getLanguage(), (Project)clazz.getProject());
            PsiMethod constructor = factory.createConstructor(clazz.getName());
            return (PsiMethod)clazz.add((PsiElement)constructor);
        }
        return clazz.getConstructors()[0];
    }

    @Override
    public boolean createStepDefinition(@NotNull GherkinStep step, @NotNull PsiFile file) {
        if (step == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "org/jetbrains/plugins/cucumber/java/steps/Java8StepDefinitionCreator", "createStepDefinition"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/cucumber/java/steps/Java8StepDefinitionCreator", "createStepDefinition"));
        }
        if (!(file instanceof PsiClassOwner)) {
            return false;
        }
        PsiClass clazz = (PsiClass)PsiTreeUtil.getChildOfType((PsiElement)file, PsiClass.class);
        if (clazz == null) {
            return false;
        }
        Project project = file.getProject();
        this.closeActiveTemplateBuilders(file);
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiElement stepDef = Java8StepDefinitionCreator.buildStepDefinitionByStep(step, file.getLanguage());
        PsiMethod constructor = Java8StepDefinitionCreator.getConstructor(clazz);
        PsiCodeBlock constructorBody = constructor.getBody();
        if (constructorBody == null) {
            return false;
        }
        PsiElement anchor = constructorBody.getFirstChild();
        if (constructorBody.getStatements().length > 0) {
            anchor = constructorBody.getStatements()[constructorBody.getStatements().length - 1];
        }
        PsiElement addedStepDef = constructorBody.addAfter(stepDef, anchor);
        this.wrapStepDefWithLineBreakAndSemicolon(addedStepDef);
        addedStepDef = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)addedStepDef);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(addedStepDef);
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        assert (editor != null);
        if (!(addedStepDef instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression stepDefCall = (PsiMethodCallExpression)addedStepDef;
        if (stepDefCall.getArgumentList().getExpressions().length < 2) {
            return false;
        }
        PsiExpression regexpElement = stepDefCall.getArgumentList().getExpressions()[0];
        PsiExpression secondArgument = stepDefCall.getArgumentList().getExpressions()[1];
        if (!(secondArgument instanceof PsiLambdaExpression)) {
            return false;
        }
        PsiLambdaExpression lambda = (PsiLambdaExpression)secondArgument;
        PsiParameterList blockVars = lambda.getParameterList();
        PsiElement lambdaBody = lambda.getBody();
        if (!(lambdaBody instanceof PsiCodeBlock)) {
            return false;
        }
        PsiCodeBlock body = (PsiCodeBlock)lambdaBody;
        this.runTemplateBuilderOnAddedStep(editor, addedStepDef, (PsiElement)regexpElement, blockVars, body);
        return true;
    }

    protected void wrapStepDefWithLineBreakAndSemicolon(PsiElement addedStepDef) {
        LeafElement linebreak = Factory.createSingleLeafElement((IElementType)TokenType.WHITE_SPACE, (CharSequence)"\n", (int)0, (int)1, null, (PsiManager)addedStepDef.getManager());
        addedStepDef.getParent().addBefore(linebreak.getPsi(), addedStepDef);
        LeafElement semicolon = Factory.createSingleLeafElement((IElementType)JavaTokenType.SEMICOLON, (CharSequence)";", (int)0, (int)1, null, (PsiManager)addedStepDef.getManager());
        addedStepDef.getParent().addAfter(semicolon.getPsi(), addedStepDef);
    }

    private static PsiElement buildStepDefinitionByStep(@NotNull GherkinStep step, Language language) {
        if (step == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "org/jetbrains/plugins/cucumber/java/steps/Java8StepDefinitionCreator", "buildStepDefinitionByStep"));
        }
        Step cucumberStep = new Step(new ArrayList(), step.getKeyword().getText(), step.getStepName(), Integer.valueOf(0), null, null);
        SnippetGenerator generator = new SnippetGenerator((Snippet)new Java8Snippet());
        String snippet = generator.getSnippet(cucumberStep, new FunctionNameGenerator((Concatenator)new CamelCaseConcatenator())).replace("PendingException", CucumberJavaUtil.getCucumberPendingExceptionFqn((PsiElement)step)).replaceAll("\\\\\\\\", "\\\\").replaceAll("\\\\d", "\\\\\\\\d");
        JVMElementFactory factory = JVMElementFactories.requireFactory((Language)language, (Project)step.getProject());
        return factory.createExpressionFromText(snippet, (PsiElement)step);
    }
}

