/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.steps;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.oro.text.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.java.CucumberJavaUtil;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;

public class JavaStepDefinition
extends AbstractStepDefinition {
    public JavaStepDefinition(PsiElement stepDef) {
        super(stepDef);
    }

    public List<String> getVariableNames() {
        PsiElement element = this.getElement();
        if (element instanceof PsiMethod) {
            PsiParameter[] parameters = ((PsiMethod)element).getParameterList().getParameters();
            ArrayList<String> result = new ArrayList<String>();
            for (PsiParameter parameter : parameters) {
                result.add(parameter.getName());
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Nullable
    protected String getCucumberRegexFromElement(PsiElement element) {
        Object value;
        PsiExpression stepExpression;
        PsiExpressionList argumentList;
        if (element instanceof PsiMethod) {
            String patternText;
            PsiConstantEvaluationHelper evaluationHelper;
            Object constantValue;
            PsiAnnotation stepAnnotation = CucumberJavaUtil.getCucumberStepAnnotation((PsiMethod)element);
            if (stepAnnotation == null) {
                return null;
            }
            PsiAnnotationMemberValue annotationValue = CucumberJavaUtil.getAnnotationValue(stepAnnotation);
            if (annotationValue != null && (constantValue = (evaluationHelper = JavaPsiFacade.getInstance((Project)element.getProject()).getConstantEvaluationHelper()).computeConstantExpression((PsiElement)annotationValue, false)) != null && (patternText = constantValue.toString()).length() > 1) {
                return patternText.replace("\\\\", "\\").replace("\\\"", "\"");
            }
        } else if (element instanceof PsiMethodCallExpression && (argumentList = ((PsiMethodCallExpression)element).getArgumentList()).getExpressions().length > 1 && (stepExpression = argumentList.getExpressions()[0]) instanceof PsiLiteralExpression && (value = ((PsiLiteralExpression)stepExpression).getValue()) instanceof String) {
            return (String)value;
        }
        return null;
    }

    public boolean matches(String stepName) {
        Pattern perlPattern = this.getPattern();
        if (perlPattern != null) {
            java.util.regex.Pattern pattern = java.util.regex.Pattern.compile(perlPattern.getPattern());
            Matcher m = pattern.matcher(stepName);
            return m.matches();
        }
        return false;
    }
}

