/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.injection;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.DeferredIconImpl;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.intellij.plugins.markdown.injection.CodeFenceLanguageProvider;
import org.intellij.plugins.markdown.injection.LanguageGuesser;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageListCompletionContributor
extends CompletionContributor {
    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/intellij/plugins/markdown/injection/LanguageListCompletionContributor", "beforeCompletion"));
        }
        if (context.getFile() instanceof MarkdownFile) {
            context.setDummyIdentifier("IntellijIdeaRulezzz \n");
        }
    }

    public boolean invokeAutoPopup(@NotNull PsiElement position, char typeChar) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/intellij/plugins/markdown/injection/LanguageListCompletionContributor", "invokeAutoPopup"));
        }
        return typeChar == '`' && position.getNode().getElementType() == MarkdownTokenTypes.CODE_FENCE_START;
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/intellij/plugins/markdown/injection/LanguageListCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/intellij/plugins/markdown/injection/LanguageListCompletionContributor", "fillCompletionVariants"));
        }
        PsiElement completionElement = parameters.getPosition();
        if (PsiUtilCore.getElementType((PsiElement)completionElement) == MarkdownTokenTypes.FENCE_LANG) {
            LanguageListCompletionContributor.doFillVariants(parameters, result);
        }
    }

    private static void doFillVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/intellij/plugins/markdown/injection/LanguageListCompletionContributor", "doFillVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/intellij/plugins/markdown/injection/LanguageListCompletionContributor", "doFillVariants"));
        }
        for (CodeFenceLanguageProvider codeFenceLanguageProvider : LanguageGuesser.INSTANCE.getCodeFenceLanguageProviders()) {
            List<LookupElement> lookups = codeFenceLanguageProvider.getCompletionVariantsForInfoString(parameters);
            for (LookupElement lookupElement : lookups) {
                result.addElement((LookupElement)LookupElementDecorator.withInsertHandler((LookupElement)lookupElement, (context, item) -> {
                    if (parameters == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/intellij/plugins/markdown/injection/LanguageListCompletionContributor", "lambda$doFillVariants$0"));
                    }
                    new MyInsertHandler(parameters).handleInsert(context, item);
                    lookupElement.handleInsert(context);
                }));
            }
        }
        for (Map.Entry entry : LanguageGuesser.INSTANCE.getLangToLanguageMap().entrySet()) {
            Language language = (Language)entry.getValue();
            LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)((String)entry.getKey())).withIcon((Icon)new DeferredIconImpl(null, (Object)language, true, language1 -> {
                LanguageFileType fileType = language1.getAssociatedFileType();
                return fileType != null ? fileType.getIcon() : null;
            })).withTypeText(language.getDisplayName(), true).withInsertHandler((InsertHandler)new MyInsertHandler(parameters));
            result.addElement((LookupElement)lookupElementBuilder);
        }
    }

    public static boolean isInMiddleOfUncollapsedFence(@Nullable PsiElement element, int offset) {
        if (element == null) {
            return false;
        }
        if (PsiUtilCore.getElementType((PsiElement)element) == MarkdownTokenTypes.CODE_FENCE_START) {
            TextRange range = element.getTextRange();
            return range.getStartOffset() + range.getEndOffset() == offset * 2;
        }
        if (PsiUtilCore.getElementType((PsiElement)element) == MarkdownTokenTypes.TEXT && PsiUtilCore.getElementType((PsiElement)element.getParent()) == MarkdownElementTypes.CODE_SPAN) {
            TextRange range = element.getTextRange();
            TextRange parentRange = element.getParent().getTextRange();
            return range.getStartOffset() - parentRange.getStartOffset() == parentRange.getEndOffset() - range.getEndOffset();
        }
        return false;
    }

    private static class MyInsertHandler
    implements InsertHandler<LookupElement> {
        private final CompletionParameters myParameters;

        public MyInsertHandler(CompletionParameters parameters) {
            this.myParameters = parameters;
        }

        public void handleInsert(InsertionContext context, LookupElement item) {
            if (LanguageListCompletionContributor.isInMiddleOfUncollapsedFence(this.myParameters.getOriginalPosition(), context.getStartOffset())) {
                context.getDocument().insertString(context.getTailOffset(), (CharSequence)"\n\n");
                context.getEditor().getCaretModel().moveCaretRelatively(1, 0, false, false, false);
            }
        }
    }
}

