/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.util.Disposer;
import javax.swing.JComponent;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.settings.MarkdownApplicationSettings;
import org.intellij.plugins.markdown.settings.MarkdownCssSettingsForm;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownCssConfigurable
implements SearchableConfigurable {
    @Nullable
    private MarkdownCssSettingsForm myForm;
    @NotNull
    private MarkdownApplicationSettings myMarkdownApplicationSettings;

    public MarkdownCssConfigurable(@NotNull MarkdownApplicationSettings markdownApplicationSettings) {
        if (markdownApplicationSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markdownApplicationSettings", "org/intellij/plugins/markdown/settings/MarkdownCssConfigurable", "<init>"));
        }
        this.myForm = null;
        this.myMarkdownApplicationSettings = markdownApplicationSettings;
    }

    @NotNull
    public String getId() {
        if ("Settings.Markdown.Css" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/settings/MarkdownCssConfigurable", "getId"));
        }
        return "Settings.Markdown.Css";
    }

    @Nls
    public String getDisplayName() {
        return MarkdownBundle.message("settings.markdown.css.name", new Object[0]);
    }

    @NotNull
    public JComponent createComponent() {
        JComponent jComponent = this.getForm().getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/settings/MarkdownCssConfigurable", "createComponent"));
        }
        return jComponent;
    }

    @NotNull
    public MarkdownCssSettingsForm getForm() {
        if (this.myForm == null) {
            this.myForm = new MarkdownCssSettingsForm();
        }
        MarkdownCssSettingsForm markdownCssSettingsForm = this.myForm;
        if (markdownCssSettingsForm == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/settings/MarkdownCssConfigurable", "getForm"));
        }
        return markdownCssSettingsForm;
    }

    public boolean isModified() {
        return !this.getForm().getMarkdownCssSettings().equals(this.myMarkdownApplicationSettings.getMarkdownCssSettings());
    }

    public void apply() throws ConfigurationException {
        this.myMarkdownApplicationSettings.setMarkdownCssSettings(this.getForm().getMarkdownCssSettings());
    }

    public void reset() {
        this.getForm().setMarkdownCssSettings(this.myMarkdownApplicationSettings.getMarkdownCssSettings());
    }

    public void disposeUIResources() {
        if (this.myForm != null) {
            Disposer.dispose((Disposable)this.myForm);
        }
        this.myForm = null;
    }
}

