/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.structureView;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import org.intellij.plugins.markdown.structureView.MarkdownStructureElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownStructureViewFactory
implements PsiStructureViewFactory {
    @Nullable
    public StructureViewBuilder getStructureViewBuilder(final @NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/intellij/plugins/markdown/structureView/MarkdownStructureViewFactory", "getStructureViewBuilder"));
        }
        return new TreeBasedStructureViewBuilder(){

            @NotNull
            public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
                MarkdownStructureViewModel markdownStructureViewModel = new MarkdownStructureViewModel(psiFile, editor);
                if (markdownStructureViewModel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/structureView/MarkdownStructureViewFactory$1", "createStructureViewModel"));
                }
                return markdownStructureViewModel;
            }
        };
    }

    private static class MarkdownStructureViewModel
    extends StructureViewModelBase {
        public MarkdownStructureViewModel(@NotNull PsiFile psiFile, @Nullable Editor editor) {
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/intellij/plugins/markdown/structureView/MarkdownStructureViewFactory$MarkdownStructureViewModel", "<init>"));
            }
            super(psiFile, editor, (StructureViewTreeElement)new MarkdownStructureElement((PsiElement)psiFile));
        }

        @Nullable
        protected Object findAcceptableElement(PsiElement element) {
            while (element != null && !MarkdownStructureElement.PRESENTABLE_TYPES.contains(PsiUtilCore.getElementType((PsiElement)element))) {
                IElementType parentType = PsiUtilCore.getElementType((PsiElement)element.getParent());
                PsiElement previous = element.getPrevSibling();
                if (previous == null || !MarkdownStructureElement.TRANSPARENT_CONTAINERS.contains(parentType)) {
                    element = element.getParent();
                    continue;
                }
                element = previous;
            }
            return element;
        }
    }
}

