/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.pom.Navigatable;
import org.intellij.plugins.markdown.ui.preview.MarkdownPreviewFileEditor;
import org.intellij.plugins.markdown.ui.split.SplitFileEditor;
import org.jetbrains.annotations.NotNull;

public class MarkdownSplitEditor
extends SplitFileEditor<TextEditor, MarkdownPreviewFileEditor>
implements TextEditor {
    public MarkdownSplitEditor(@NotNull TextEditor mainEditor, @NotNull MarkdownPreviewFileEditor secondEditor) {
        if (mainEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainEditor", "org/intellij/plugins/markdown/ui/preview/MarkdownSplitEditor", "<init>"));
        }
        if (secondEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "secondEditor", "org/intellij/plugins/markdown/ui/preview/MarkdownSplitEditor", "<init>"));
        }
        super(mainEditor, secondEditor);
        mainEditor.getEditor().getCaretModel().addCaretListener((CaretListener)new MyCaretListener(secondEditor));
    }

    @NotNull
    public String getName() {
        if ("Markdown split editor" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/preview/MarkdownSplitEditor", "getName"));
        }
        return "Markdown split editor";
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = ((TextEditor)this.getMainEditor()).getEditor();
        if (editor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/preview/MarkdownSplitEditor", "getEditor"));
        }
        return editor;
    }

    public boolean canNavigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "org/intellij/plugins/markdown/ui/preview/MarkdownSplitEditor", "canNavigateTo"));
        }
        return ((TextEditor)this.getMainEditor()).canNavigateTo(navigatable);
    }

    public void navigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "org/intellij/plugins/markdown/ui/preview/MarkdownSplitEditor", "navigateTo"));
        }
        ((TextEditor)this.getMainEditor()).navigateTo(navigatable);
    }

    private static class MyCaretListener
    implements CaretListener {
        @NotNull
        private final MarkdownPreviewFileEditor myPreviewFileEditor;

        public MyCaretListener(@NotNull MarkdownPreviewFileEditor previewFileEditor) {
            if (previewFileEditor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previewFileEditor", "org/intellij/plugins/markdown/ui/preview/MarkdownSplitEditor$MyCaretListener", "<init>"));
            }
            this.myPreviewFileEditor = previewFileEditor;
        }

        public void caretPositionChanged(CaretEvent e) {
            Editor editor = e.getEditor();
            if (editor.getCaretModel().getCaretCount() != 1) {
                return;
            }
            int offset = editor.logicalPositionToOffset(e.getNewPosition());
            this.myPreviewFileEditor.scrollToSrcOffset(offset);
        }
    }
}

