/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.impl;

import com.intellij.database.remote.jdbc.impl.JdbcRemoteObject;
import com.intellij.database.remote.jdbc.impl.ReflectionHelper;
import com.intellij.openapi.util.Getter;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;

public class OracleHelper {
    private static boolean ourIsInitialized;
    private static boolean ourIsLtzTimestampInGmt;
    private static boolean ourIsTimestampInGmt;
    private static TimeZone ourSessionTimeZone;

    public static void init(Getter<Connection> connectionGetter) {
        String driverVersion;
        if (ourIsInitialized) {
            return;
        }
        try {
            DatabaseMetaData metaData = ((Connection)connectionGetter.get()).getMetaData();
            driverVersion = metaData.getDriverVersion();
        }
        catch (SQLException e) {
            driverVersion = "";
        }
        if (VersionComparatorUtil.compare((String)driverVersion, (String)"11.1.0.7") < 0) {
            ourIsTimestampInGmt = false;
        } else {
            Object p = ReflectionHelper.tryInvokeMethod(connectionGetter.get(), "getProperties", null, null);
            if (p instanceof Properties) {
                String timestampTzInGmtPropStr = ((Properties)p).getProperty("oracle.jdbc.timestampTzInGmt", "true");
                ourIsTimestampInGmt = timestampTzInGmtPropStr.equalsIgnoreCase("true");
            } else {
                ourIsTimestampInGmt = true;
            }
            ourIsLtzTimestampInGmt = VersionComparatorUtil.compare((String)driverVersion, (String)"11.2.0.2") >= 0;
        }
        Object value = ReflectionHelper.tryInvokeMethod(connectionGetter.get(), "getSessionTimeZone", null, null);
        ourSessionTimeZone = value instanceof String ? TimeZone.getTimeZone((String)value) : null;
        ourIsInitialized = true;
    }

    public static boolean isLtzTimestampInGmt(Getter<Connection> connection) {
        OracleHelper.init(connection);
        return ourIsLtzTimestampInGmt;
    }

    public static boolean isTimestampInGmt(Getter<Connection> connection) {
        OracleHelper.init(connection);
        return ourIsTimestampInGmt;
    }

    public static Object convertValue(JdbcRemoteObject remoteObject, String className, Object o, Getter<Connection> connectionGetter) throws RemoteException, SQLException {
        Object opaqueTypeName;
        Object value;
        if (className.startsWith("oracle.xdb.XMLType") && (value = OracleHelper.tryMethodWithConnection(o, "getString", null)) != null) {
            return value;
        }
        if (className.equals("oracle.sql.TIMESTAMPTZ")) {
            value = OracleHelper.tryMethodWithConnection(o, "timestampValue", connectionGetter);
            if (value instanceof Timestamp) {
                Calendar calendar;
                TimeZone timeZone = OracleHelper.extractTimeZone(o);
                if (OracleHelper.isTimestampInGmt(connectionGetter)) {
                    calendar = Calendar.getInstance(timeZone);
                    calendar.setTime((Date)value);
                } else {
                    calendar = Calendar.getInstance();
                    calendar.setTime((Date)value);
                    if (timeZone != null) {
                        calendar.getTimeZone().setID(timeZone.getID());
                        calendar.getTimeZone().setRawOffset(timeZone.getRawOffset());
                    }
                }
                value = new Timestamp(calendar.getTimeInMillis());
            }
        } else if (className.equals("oracle.sql.TIMESTAMPLTZ")) {
            value = ReflectionHelper.tryInvokeMethod(null, o.getClass(), "toTimestamp", new Class[]{Connection.class, byte[].class}, new Object[]{connectionGetter.get(), ReflectionHelper.tryInvokeMethod(o, "toBytes", null, null)});
            if (value instanceof Timestamp) {
                Calendar calendar = ourSessionTimeZone != null ? Calendar.getInstance(ourSessionTimeZone) : Calendar.getInstance();
                if (OracleHelper.isLtzTimestampInGmt(connectionGetter)) {
                    calendar.setTimeInMillis(((Timestamp)value).getTime());
                } else {
                    Calendar localCalendar = Calendar.getInstance();
                    localCalendar.setTime((Date)value);
                    calendar.set(localCalendar.get(1), localCalendar.get(2), localCalendar.get(5), localCalendar.get(11), localCalendar.get(12), localCalendar.get(13));
                    calendar.set(14, ((Timestamp)value).getNanos() / 1000000);
                }
                value = new Timestamp(calendar.getTimeInMillis());
            }
        } else if (className.equals("oracle.sql.STRUCT")) {
            Object attributes = ReflectionHelper.tryInvokeMethod(o, o.getClass(), "getAttributes", new Class[0], new Object[0]);
            value = remoteObject.wrapIfNeeded(attributes, connectionGetter);
        } else {
            value = OracleHelper.tryMethodWithConnection(o, "toJdbc", null);
            if (value == null) {
                value = OracleHelper.tryMethodWithConnection(o, "stringValue", null);
            }
        }
        if (value != null) {
            return value;
        }
        Object object = opaqueTypeName = className.equals("oracle.sql.OPAQUE") ? ReflectionHelper.tryInvokeMethod(ReflectionHelper.tryInvokeMethod(o, "getDescriptor", null, null), "getName", null, null) : null;
        if (opaqueTypeName instanceof String) {
            return "<failed to load> " + className + "\n" + ("SYS.XMLTYPE".equalsIgnoreCase((String)opaqueTypeName) ? "Oracle XML DB library" : className + " support library") + " is missing in the database driver";
        }
        return null;
    }

    private static Object tryMethodWithConnection(Object o, String methodName, Getter<Connection> connectionGetter) {
        Object[] objectArray;
        Class[] classArray;
        if (connectionGetter == null) {
            classArray = ArrayUtil.EMPTY_CLASS_ARRAY;
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = Connection.class;
        }
        if (connectionGetter == null) {
            objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = connectionGetter.get();
        }
        Object value = ReflectionHelper.tryInvokeMethod(o, methodName, classArray, objectArray);
        return value != null && value.getClass().getClassLoader() == null ? value : null;
    }

    public static TimeZone extractTimeZone(Object o) {
        String regionName;
        Object b = ReflectionHelper.tryInvokeMethod(o, "toBytes", null, null);
        if (!(b instanceof byte[])) {
            return null;
        }
        byte[] bytes = (byte[])b;
        if ((bytes[11] & 0xFFFFFF80) != 0) {
            int regionCode = (bytes[11] & 0x7F) << 6;
            regionName = (String)ReflectionHelper.tryInvokeMethod("oracle.sql.ZONEIDMAP", "getRegion", new Class[]{Integer.TYPE}, new Object[]{regionCode += (bytes[12] & 0xFC) >> 2});
        } else {
            int hourOffset = bytes[11] - 20;
            int minuteOffset = bytes[12] - 60;
            regionName = String.format("GMT%+03d:%02d", hourOffset, Math.abs(minuteOffset));
        }
        return TimeZone.getTimeZone(regionName);
    }
}

