/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.actions;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.ui.Refreshable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.application.FileGrouper;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.PerforceNumberNameSynchronizer;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public class RevertAllUnchangedFilesAction
extends AbstractVcsAction {
    protected void update(@NotNull VcsContext vcsContext, @NotNull Presentation presentation) {
        Object[] files;
        if (vcsContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsContext", "org/jetbrains/idea/perforce/actions/RevertAllUnchangedFilesAction", "update"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "org/jetbrains/idea/perforce/actions/RevertAllUnchangedFilesAction", "update"));
        }
        Project project = vcsContext.getProject();
        if (project == null) {
            presentation.setVisible(false);
            return;
        }
        Refreshable panel = vcsContext.getRefreshableDialog();
        boolean visible = panel instanceof CheckinProjectPanel ? ((CheckinProjectPanel)panel).vcsIsAffected("Perforce") : !ArrayUtil.isEmpty((Object[])(files = vcsContext.getSelectedFiles())) && RevertAllUnchangedFilesAction.hasFilesUnderPerforce(Arrays.asList(files), project);
        presentation.setVisible(visible);
        presentation.setEnabled(PerforceSettings.getSettings((Project)project).ENABLED);
    }

    private static Collection<VirtualFile> getSelectedFiles(@NotNull VcsContext vcsContext) {
        if (vcsContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsContext", "org/jetbrains/idea/perforce/actions/RevertAllUnchangedFilesAction", "getSelectedFiles"));
        }
        Refreshable panel = vcsContext.getRefreshableDialog();
        if (panel instanceof CheckinProjectPanel) {
            return ((CheckinProjectPanel)panel).getRoots();
        }
        Object[] array = vcsContext.getSelectedFiles();
        if (!ArrayUtil.isEmpty((Object[])array)) {
            return Arrays.asList(array);
        }
        return Collections.emptyList();
    }

    private static boolean hasFilesUnderPerforce(Collection<VirtualFile> roots, Project project) {
        return !RevertAllUnchangedFilesAction.findFilesUnderPerforce(roots, project).isEmpty();
    }

    protected void actionPerformed(@NotNull VcsContext vcsContext) {
        if (vcsContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsContext", "org/jetbrains/idea/perforce/actions/RevertAllUnchangedFilesAction", "actionPerformed"));
        }
        CheckinProjectPanel panel = (CheckinProjectPanel)vcsContext.getRefreshableDialog();
        Collection<VirtualFile> roots = RevertAllUnchangedFilesAction.getSelectedFiles(vcsContext);
        Project project = vcsContext.getProject();
        ApplicationManager.getApplication().runWriteAction(() -> FileDocumentManager.getInstance().saveAllDocuments());
        RevertAllUnchangedFilesAction.revertUnchanged(project, roots, panel, vcsContext.getSelectedChangeLists());
    }

    public static void revertUnchanged(Project project, Collection<VirtualFile> roots, @Nullable CheckinProjectPanel panel, @Nullable ChangeList[] selection) {
        ArrayList exceptions = new ArrayList();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            if (selection != null && selection.length > 0 && RevertAllUnchangedFilesAction.revertChangeLists(project, selection, exceptions)) {
                return;
            }
            RevertAllUnchangedFilesAction.revertFiles(roots, project, exceptions);
        }, PerforceBundle.message((String)"message.title.revert.unchanged", (Object[])new Object[0]), false, project);
        RevertAllUnchangedFilesAction.refreshAndDirty(project, roots);
        if (panel != null) {
            panel.refresh();
        }
        if (!exceptions.isEmpty()) {
            AbstractVcsHelper.getInstance((Project)project).showErrors(exceptions, PerforceBundle.message((String)"message.title.revert.unchanged.files", (Object[])new Object[0]));
        }
    }

    private static void refreshAndDirty(Project project, Collection<VirtualFile> roots) {
        VfsUtil.markDirty((boolean)true, (boolean)false, (VirtualFile[])roots.toArray(new VirtualFile[roots.size()]));
        if (RevertAllUnchangedFilesAction.hasDirectories(roots)) {
            VirtualFileManager.getInstance().asyncRefresh(() -> {
                P4File.invalidateFstat(project);
                VcsDirtyScopeManager.getInstance((Project)project).markEverythingDirty();
            });
        } else {
            for (VirtualFile vFile : RevertAllUnchangedFilesAction.findFilesUnderPerforce(roots, project)) {
                ApplicationManager.getApplication().runWriteAction(() -> vFile.refresh(false, false));
                P4File.invalidateFstat(vFile);
                if (vFile.isDirectory()) {
                    VcsDirtyScopeManager.getInstance((Project)project).dirDirtyRecursively(vFile);
                    continue;
                }
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(vFile);
            }
        }
    }

    private static boolean hasDirectories(Collection<VirtualFile> roots) {
        return ContainerUtil.find(roots, file -> file.isDirectory()) != null;
    }

    private static void revertFiles(Collection<VirtualFile> roots, Project project, List<VcsException> exceptions) {
        List<VirtualFile> files = RevertAllUnchangedFilesAction.findFilesUnderPerforce(roots, project);
        MultiMap<P4Connection, VirtualFile> map = FileGrouper.distributeFilesByConnection(files, project);
        for (P4Connection connection : map.keySet()) {
            try {
                List paths = ContainerUtil.map2List((Collection)map.get((Object)connection), file -> P4File.create(file).getRecursivePath());
                PerforceRunner.getInstance(project).revertUnchanged(connection, paths);
            }
            catch (VcsException e1) {
                exceptions.add(e1);
            }
        }
    }

    private static List<VirtualFile> findFilesUnderPerforce(Collection<VirtualFile> roots, Project project) {
        PerforceVcs vcs = PerforceVcs.getInstance(project);
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        return ContainerUtil.findAll(roots, file -> vcsManager.getVcsFor(file) == vcs);
    }

    private static boolean revertChangeLists(Project project, ChangeList[] selectedChangeLists, List<VcsException> exceptions) {
        boolean foundAll = true;
        PerforceNumberNameSynchronizer synchronizer = PerforceNumberNameSynchronizer.getInstance(project);
        Collection<P4Connection> connectionList = PerforceSettings.getSettings(project).getAllConnections();
        HashSet<Pair> numbers = new HashSet<Pair>();
        for (P4Connection connection : connectionList) {
            try {
                PerforceManager.ensureValidClient(project, connection);
            }
            catch (VcsException e) {
                exceptions.add(e);
                continue;
            }
            ConnectionKey connectionKey = connection.getConnectionKey();
            for (ChangeList changeList : selectedChangeLists) {
                Collection<Long> exNumbers = synchronizer.getNumbers(connectionKey, changeList.getName());
                if (exNumbers != null && !exNumbers.isEmpty()) {
                    for (Long exNumber : exNumbers) {
                        numbers.add(Pair.create((Object)exNumber, (Object)connection));
                    }
                    continue;
                }
                foundAll = false;
            }
        }
        for (Pair pair : numbers) {
            try {
                PerforceRunner.getInstance(project).revertUnchanged((P4Connection)pair.getSecond(), (Long)pair.getFirst());
            }
            catch (VcsException e1) {
                exceptions.add(e1);
            }
        }
        return foundAll;
    }
}

