/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.operations;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.operations.VcsOperation;

public abstract class VcsOperationOnPath
extends VcsOperation {
    protected String myPath;

    protected VcsOperationOnPath() {
    }

    protected VcsOperationOnPath(String changeList, String path) {
        super(changeList);
        this.myPath = path;
    }

    public String getPath() {
        return this.myPath;
    }

    @Override
    @NotNull
    String getInputPath() {
        String string = this.getPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/operations/VcsOperationOnPath", "getInputPath"));
        }
        return string;
    }

    @Override
    @NotNull
    String getOutputPath() {
        String string = this.getPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/operations/VcsOperationOnPath", "getOutputPath"));
        }
        return string;
    }

    public void setPath(String path) {
        this.myPath = path;
    }

    protected FilePath getFilePath() {
        return VcsContextFactory.SERVICE.getInstance().createFilePathOn(new File(this.myPath), false);
    }

    @Override
    public List<String> getAffectedPaths() {
        return Collections.singletonList(this.myPath);
    }
}

