/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.j2ee.web.resin;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.intellij.j2ee.web.resin.ResinBundle;
import org.intellij.j2ee.web.resin.ResinModelBase;
import org.intellij.j2ee.web.resin.ResinModelDataBase;
import org.intellij.j2ee.web.resin.ResinPersistentData;
import org.intellij.j2ee.web.resin.resin.ResinConfiguration;
import org.intellij.j2ee.web.resin.resin.ResinInstallation;
import org.intellij.j2ee.web.resin.ui.DeploymentSettingsEditor;
import org.intellij.j2ee.web.resin.ui.RunConfigurationEditor;
import org.jetbrains.annotations.NonNls;

public class ResinModel
extends ResinModelBase<ResinLocalModelData> {
    private static final Logger LOG = Logger.getInstance(ResinModel.class);
    @NonNls
    public static final String DEPLOY_MODE_AUTO = "automatic";
    @NonNls
    public static final String DEPLOY_MODE_LAZY = "lazy";
    @NonNls
    public static final String DEPLOY_MODE_MANUAL = "manual";
    private ResinConfiguration myConfiguration;

    public SettingsEditor<CommonModel> getEditor() {
        return new RunConfigurationEditor();
    }

    public List<Pair<String, Integer>> getAddressesToCheck() {
        return Collections.singletonList(Pair.create((Object)this.getCommonModel().getHost(), (Object)this.getLocalPort()));
    }

    public ResinConfiguration getOrCreateResinConfiguration(boolean forceCreation) throws ExecutionException {
        if (this.myConfiguration == null || forceCreation) {
            this.myConfiguration = new ResinConfiguration(this);
        }
        return this.myConfiguration;
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        this.findConfFile();
        super.checkConfiguration();
    }

    public File findConfFile() throws RuntimeConfigurationException {
        String sourceConfigPath;
        File sourceConfig = null;
        ResinPersistentData persistentData = this.getHelper().getPersistentData();
        if (persistentData != null && !StringUtil.isEmpty((String)persistentData.RESIN_CONF)) {
            sourceConfig = new File(persistentData.RESIN_CONF);
        }
        if (!StringUtil.isEmpty((String)(sourceConfigPath = this.getResinConf()))) {
            sourceConfig = new File(FileUtil.toSystemDependentName((String)sourceConfigPath));
        }
        if (sourceConfig == null) {
            throw new RuntimeConfigurationException(ResinBundle.message("message.error.resin.conf.doesnt.chosen", new Object[0]));
        }
        if (!sourceConfig.exists()) {
            throw new RuntimeConfigurationException(ResinBundle.message("message.error.resin.conf.doesnt.exist", sourceConfig.getAbsolutePath()));
        }
        if (sourceConfig.isDirectory()) {
            throw new RuntimeConfigurationException(ResinBundle.message("message.error.resin.conf.directory", sourceConfig.getAbsolutePath()));
        }
        return sourceConfig;
    }

    public boolean isDebugConfiguration() {
        return ((ResinLocalModelData)this.getData()).isDebugConfiguration();
    }

    public void setDebugConfiguration(boolean debugConfiguration) {
        ((ResinLocalModelData)this.getData()).setDebugConfiguration(debugConfiguration);
    }

    public boolean isAutoBuildClassPath() {
        return ((ResinLocalModelData)this.getData()).isAutoBuildClassPath();
    }

    public void setAutoBuildClassPath(boolean autoBuildClassPath) {
        ((ResinLocalModelData)this.getData()).setAutoBuildClassPath(autoBuildClassPath);
    }

    public String getResinConf() {
        return ((ResinLocalModelData)this.getData()).getResinConf();
    }

    public void setResinConf(String resinConf) {
        ((ResinLocalModelData)this.getData()).setResinConf(resinConf);
    }

    public boolean isReadOnlyConfiguration() {
        return ((ResinLocalModelData)this.getData()).isReadOnlyConfiguration();
    }

    public void setReadOnlyConfiguration(boolean readOnlyConfiguration) {
        ((ResinLocalModelData)this.getData()).setReadOnlyConfiguration(readOnlyConfiguration);
    }

    public String getAdditionalParameters() {
        String additionalParameters = ((ResinLocalModelData)this.getData()).getAdditionalParameters();
        return additionalParameters == null ? "" : additionalParameters.trim();
    }

    public void setAdditionalParameters(String additionalParameters) {
        ((ResinLocalModelData)this.getData()).setAdditionalParameters(additionalParameters);
    }

    public String getDeployMode() {
        String deployMode = ((ResinLocalModelData)this.getData()).getDeployMode();
        return deployMode == null ? DEPLOY_MODE_MANUAL : deployMode;
    }

    public void setDeployMode(String deployMode) {
        ((ResinLocalModelData)this.getData()).setDeployMode(deployMode);
    }

    @Override
    protected ResinLocalModelData createResinModelData() {
        return new ResinLocalModelData();
    }

    private File getWebAppFileDestination(File webAppFile) {
        ResinInstallation installation = this.getInstallation();
        LOG.assertTrue(installation != null);
        File homeDir = installation.getResinHome();
        File webAppsDir = new File(homeDir, "webapps");
        if (!webAppsDir.exists()) {
            LOG.error("Can't find webapps folder");
            return null;
        }
        return new File(webAppsDir, webAppFile.getName());
    }

    @Override
    public boolean transferFile(File webAppFile) {
        File webAppFileDestination = this.getWebAppFileDestination(webAppFile);
        if (webAppFileDestination == null) {
            return false;
        }
        try {
            FileUtil.copyFileOrDir((File)webAppFile, (File)webAppFileDestination);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteFile(File webAppFile) {
        File webAppFileDestination = this.getWebAppFileDestination(webAppFile);
        if (webAppFileDestination == null) {
            return false;
        }
        return FileUtil.delete((File)webAppFileDestination);
    }

    @Override
    public SettingsEditor<DeploymentModel> createAdditionalDeploymentSettingsEditor(CommonModel commonModel, DeploymentSource source) {
        return new DeploymentSettingsEditor(commonModel, source);
    }

    public static class ResinLocalModelData
    extends ResinModelDataBase {
        private String myResinConf = "";
        private boolean myDebugConfiguration = false;
        private boolean myAutoBuildClassPath = false;
        private boolean myReadOnlyConfiguration = false;
        private String myAdditionalParameters = "";
        private String myDeployMode = "automatic";

        public String getResinConf() {
            return this.myResinConf;
        }

        public void setResinConf(String resinConf) {
            this.myResinConf = resinConf;
        }

        public boolean isDebugConfiguration() {
            return this.myDebugConfiguration;
        }

        public void setDebugConfiguration(boolean debugConfiguration) {
            this.myDebugConfiguration = debugConfiguration;
        }

        public boolean isAutoBuildClassPath() {
            return this.myAutoBuildClassPath;
        }

        public void setAutoBuildClassPath(boolean autoBuildClassPath) {
            this.myAutoBuildClassPath = autoBuildClassPath;
        }

        public boolean isReadOnlyConfiguration() {
            return this.myReadOnlyConfiguration;
        }

        public void setReadOnlyConfiguration(boolean readOnlyConfiguration) {
            this.myReadOnlyConfiguration = readOnlyConfiguration;
        }

        public String getAdditionalParameters() {
            return this.myAdditionalParameters;
        }

        public void setAdditionalParameters(String additionalParameters) {
            this.myAdditionalParameters = additionalParameters;
        }

        public String getDeployMode() {
            return this.myDeployMode;
        }

        public void setDeployMode(String deployMode) {
            this.myDeployMode = deployMode;
        }
    }
}

