/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBList;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.branchConfig.BranchConfigurationDialog;
import org.jetbrains.idea.svn.branchConfig.InfoReliability;
import org.jetbrains.idea.svn.branchConfig.NewRootBunch;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.branchConfig.SvnBranchItem;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class SelectBranchPopup {
    private static final String CONFIGURE_MESSAGE = SvnBundle.message("configure.branches.item", new Object[0]);

    private SelectBranchPopup() {
    }

    public static void show(@NotNull Project project, @NotNull VirtualFile file, @NotNull BranchSelectedCallback callback, @Nullable String title) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup", "show"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup", "show"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup", "show"));
        }
        SelectBranchPopup.show(project, file, callback, title, null);
    }

    public static void show(@NotNull Project project, @NotNull VirtualFile file, @NotNull BranchSelectedCallback callback, @Nullable String title, @Nullable Component component) {
        RootUrlInfo rootUrlInfo;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup", "show"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup", "show"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup", "show"));
        }
        SvnFileUrlMapping urlMapping = SvnVcs.getInstance(project).getSvnFileUrlMapping();
        SVNURL svnurl = urlMapping.getUrlForFile(VfsUtilCore.virtualToIoFile((VirtualFile)file));
        if (svnurl != null && (rootUrlInfo = urlMapping.getWcRootForUrl(svnurl.toString())) != null) {
            SelectBranchPopup.showForBranchRoot(project, rootUrlInfo.getVirtualFile(), callback, title, component);
        }
    }

    public static void showForBranchRoot(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull BranchSelectedCallback callback, @Nullable String title) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup", "showForBranchRoot"));
        }
        if (vcsRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsRoot", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup", "showForBranchRoot"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup", "showForBranchRoot"));
        }
        SelectBranchPopup.showForBranchRoot(project, vcsRoot, callback, title, null);
    }

    public static void showForBranchRoot(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull BranchSelectedCallback callback, @Nullable String title, @Nullable Component component) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup", "showForBranchRoot"));
        }
        if (vcsRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsRoot", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup", "showForBranchRoot"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup", "showForBranchRoot"));
        }
        SvnBranchConfigurationNew configuration = SvnBranchConfigurationManager.getInstance(project).get(vcsRoot);
        ArrayList<String> items = new ArrayList<String>();
        if (!StringUtil.isEmptyOrSpaces((String)configuration.getTrunkUrl())) {
            items.add(SelectBranchPopup.getTrunkString(configuration));
        }
        items.addAll(configuration.getBranchUrls());
        items.add(CONFIGURE_MESSAGE);
        BranchBasesPopupStep step = new BranchBasesPopupStep(project, vcsRoot, configuration, callback, items, title, component);
        step.showPopupAt((JBPopup)JBPopupFactory.getInstance().createListPopup((ListPopupStep)step));
    }

    @NotNull
    private static String getTrunkString(@NotNull SvnBranchConfigurationNew configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup", "getTrunkString"));
        }
        String string = configuration.getTrunkUrl() + " (trunk)";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup", "getTrunkString"));
        }
        return string;
    }

    @NotNull
    private static String getBranchName(@NotNull SvnBranchItem branch) {
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup", "getBranchName"));
        }
        String string = SVNPathUtil.tail((String)branch.getUrl());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup", "getBranchName"));
        }
        return string;
    }

    private static class BranchRenderer
    extends JPanel
    implements ListCellRenderer<Object> {
        private final JLabel myUrlLabel = new JLabel();
        private final JLabel myDateLabel = new JLabel();

        public BranchRenderer() {
            super(new BorderLayout());
            this.add((Component)this.myUrlLabel, "West");
            this.add((Component)this.myDateLabel, "East");
            this.myUrlLabel.setBorder(JBUI.Borders.empty((int)1));
            this.myDateLabel.setHorizontalAlignment(4);
            this.myDateLabel.setBorder(JBUI.Borders.empty((int)1));
            this.myDateLabel.setForeground(UIUtil.getInactiveTextColor());
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected || cellHasFocus) {
                this.setBackground(UIUtil.getListSelectionBackground());
                Color selectedForegroundColor = UIUtil.getListSelectionForeground();
                this.myUrlLabel.setForeground(selectedForegroundColor);
                this.myDateLabel.setForeground(selectedForegroundColor);
                this.setForeground(selectedForegroundColor);
            } else {
                this.setBackground(UIUtil.getListBackground());
                Color foregroundColor = UIUtil.getListForeground();
                this.myUrlLabel.setForeground(foregroundColor);
                this.myDateLabel.setForeground(UIUtil.getInactiveTextColor());
                this.setForeground(foregroundColor);
            }
            if (value instanceof String) {
                this.myUrlLabel.setText((String)value);
                this.myDateLabel.setText("");
            } else {
                SvnBranchItem item = (SvnBranchItem)value;
                this.myUrlLabel.setText(SelectBranchPopup.getBranchName(item));
                long creationMillis = item.getCreationDateMillis();
                this.myDateLabel.setText(creationMillis > 0L ? DateFormatUtil.formatDate((long)creationMillis) : "");
            }
            return this;
        }
    }

    private static class BranchBasesPopupStep
    extends BaseListPopupStep<String> {
        @NotNull
        private final Project myProject;
        @NotNull
        private final VirtualFile myVcsRoot;
        @NotNull
        private final SvnBranchConfigurationNew myConfiguration;
        @NotNull
        private final BranchSelectedCallback myCallback;
        @Nullable
        private final Component myComponent;
        @NotNull
        private final String myTrunkString;
        private static final String REFRESH_MESSAGE = SvnBundle.message("refresh.branches.item", new Object[0]);

        public BranchBasesPopupStep(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull SvnBranchConfigurationNew configuration, @NotNull BranchSelectedCallback callback, @NotNull List<String> items, @Nullable String title, @Nullable Component component) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup$BranchBasesPopupStep", "<init>"));
            }
            if (vcsRoot == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsRoot", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup$BranchBasesPopupStep", "<init>"));
            }
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup$BranchBasesPopupStep", "<init>"));
            }
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup$BranchBasesPopupStep", "<init>"));
            }
            if (items == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup$BranchBasesPopupStep", "<init>"));
            }
            this.myProject = project;
            this.myVcsRoot = vcsRoot;
            this.myConfiguration = configuration;
            this.myTrunkString = SelectBranchPopup.getTrunkString(configuration);
            this.myCallback = callback;
            this.myComponent = component;
            this.init(title, items, null);
        }

        public ListSeparator getSeparatorAbove(String value) {
            return CONFIGURE_MESSAGE.equals(value) || REFRESH_MESSAGE.equals(value) ? new ListSeparator("") : null;
        }

        @NotNull
        public String getTextFor(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup$BranchBasesPopupStep", "getTextFor"));
            }
            int pos = value.lastIndexOf(47);
            if (pos < 0) {
                String string = value;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup$BranchBasesPopupStep", "getTextFor"));
                }
                return string;
            }
            if (this.myConfiguration.getTrunkUrl() == null || !value.startsWith(this.myConfiguration.getTrunkUrl())) {
                String string = value.substring(pos + 1) + "...";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup$BranchBasesPopupStep", "getTextFor"));
                }
                return string;
            }
            String string = value.substring(pos + 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup$BranchBasesPopupStep", "getTextFor"));
            }
            return string;
        }

        public boolean hasSubstep(String selectedValue) {
            return false;
        }

        public PopupStep onChosen(String selectedValue, boolean finalChoice) {
            if (CONFIGURE_MESSAGE.equals(selectedValue)) {
                return this.doFinalStep(() -> BranchConfigurationDialog.configureBranches(this.myProject, this.myVcsRoot));
            }
            if (this.myTrunkString.equals(selectedValue)) {
                return this.doFinalStep(() -> this.myCallback.branchSelected(this.myProject, this.myConfiguration, this.myConfiguration.getTrunkUrl(), -1L));
            }
            if (selectedValue.equals(this.myConfiguration.getTrunkUrl())) {
                return this.doFinalStep(() -> this.myCallback.branchSelected(this.myProject, this.myConfiguration, selectedValue, -1L));
            }
            this.showBranchPopup(selectedValue);
            return FINAL_CHOICE;
        }

        private void loadBranches(final @NotNull String selectedBranchesHolder, final @NotNull Runnable runnable) {
            if (selectedBranchesHolder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedBranchesHolder", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup$BranchBasesPopupStep", "loadBranches"));
            }
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup$BranchBasesPopupStep", "loadBranches"));
            }
            new Task.Backgroundable(this.myProject, SvnBundle.message("compare.with.branch.progress.loading.branches", new Object[0]), true){

                public void onFinished() {
                    runnable.run();
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup$BranchBasesPopupStep$1", "run"));
                    }
                    NewRootBunch manager = SvnBranchConfigurationManager.getInstance(this.myProject).getSvnBranchConfigManager();
                    manager.reloadBranches(myVcsRoot, selectedBranchesHolder, InfoReliability.setByUser, false);
                }
            }.queue();
        }

        private void showBranchPopup(String selectedValue) {
            List<SvnBranchItem> branches = this.myConfiguration.getBranches(selectedValue);
            if (branches == null) {
                return;
            }
            Object[] items = new Object[branches.size() + 1];
            System.arraycopy(branches.toArray(), 0, items, 0, branches.size());
            items[items.length - 1] = REFRESH_MESSAGE;
            JBList branchList = new JBList(items);
            branchList.setCellRenderer((ListCellRenderer)new BranchRenderer());
            JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)branchList).setTitle(SVNPathUtil.tail((String)selectedValue)).setResizable(true).setItemChoosenCallback(() -> {
                if (REFRESH_MESSAGE.equals(branchList.getSelectedValue())) {
                    this.loadBranches(selectedValue, () -> this.showBranchPopup(selectedValue));
                    return;
                }
                SvnBranchItem item = (SvnBranchItem)branchList.getSelectedValue();
                if (item != null) {
                    this.myCallback.branchSelected(this.myProject, this.myConfiguration, item.getUrl(), item.getRevision());
                }
            }).setFilteringEnabled(item -> item instanceof SvnBranchItem ? SelectBranchPopup.getBranchName((SvnBranchItem)item) : null).createPopup();
            this.showPopupAt(popup);
        }

        public void showPopupAt(@NotNull JBPopup listPopup) {
            if (listPopup == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listPopup", "org/jetbrains/idea/svn/branchConfig/SelectBranchPopup$BranchBasesPopupStep", "showPopupAt"));
            }
            if (this.myComponent == null) {
                listPopup.showCenteredInCurrentWindow(this.myProject);
            } else {
                listPopup.showInCenterOf(this.myComponent);
            }
        }
    }

    public static interface BranchSelectedCallback {
        public void branchSelected(Project var1, SvnBranchConfigurationNew var2, String var3, long var4);
    }
}

