/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.checkin;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.checkin.CommitEventHandler;
import org.jetbrains.idea.svn.checkin.CommitEventType;
import org.tmatesoft.svn.core.SVNCancelException;

public class IdeaCommitHandler
implements CommitEventHandler,
ProgressTracker {
    private static final Logger LOG = Logger.getInstance(IdeaCommitHandler.class);
    @Nullable
    private final ProgressIndicator myProgress;
    @NotNull
    private final List<VirtualFile> myDeletedFiles = ContainerUtil.newArrayList();
    private final boolean myCheckCancel;
    private final boolean myTrackDeletedFiles;

    public IdeaCommitHandler(@Nullable ProgressIndicator progress) {
        this(progress, false, false);
    }

    public IdeaCommitHandler(@Nullable ProgressIndicator progress, boolean checkCancel, boolean trackDeletedFiles) {
        this.myProgress = progress;
        this.myCheckCancel = checkCancel;
        this.myTrackDeletedFiles = trackDeletedFiles;
    }

    @NotNull
    public List<VirtualFile> getDeletedFiles() {
        List<VirtualFile> list = this.myDeletedFiles;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/checkin/IdeaCommitHandler", "getDeletedFiles"));
        }
        return list;
    }

    @Override
    public void commitEvent(CommitEventType type, File target) {
        if (this.myProgress == null) {
            return;
        }
        this.myProgress.checkCanceled();
        this.updateProgress(type, target.getPath());
    }

    @Override
    public void committedRevision(long revNum) {
        if (this.myProgress == null) {
            return;
        }
        this.myProgress.checkCanceled();
        this.myProgress.setText2(SvnBundle.message("status.text.comitted.revision", revNum));
    }

    public void consume(ProgressEvent event) {
        String path = event.getPath();
        if (path != null) {
            CommitEventType eventType = IdeaCommitHandler.convert(event.getAction());
            if (CommitEventType.deleting.equals((Object)eventType) && this.myTrackDeletedFiles) {
                this.trackDeletedFile(event);
            }
            this.updateProgress(eventType, path);
        }
    }

    @Override
    public void checkCancelled() throws SVNCancelException {
        if (this.myCheckCancel && this.myProgress != null) {
            try {
                this.myProgress.checkCanceled();
            }
            catch (ProcessCanceledException ex) {
                throw new SVNCancelException();
            }
        }
    }

    private void updateProgress(@NotNull CommitEventType type, @NotNull String target) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/idea/svn/checkin/IdeaCommitHandler", "updateProgress"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/checkin/IdeaCommitHandler", "updateProgress"));
        }
        if (this.myProgress == null) {
            return;
        }
        if (CommitEventType.adding.equals((Object)type)) {
            this.myProgress.setText2(SvnBundle.message("progress.text2.adding", target));
        } else if (CommitEventType.deleting.equals((Object)type)) {
            this.myProgress.setText2(SvnBundle.message("progress.text2.deleting", target));
        } else if (CommitEventType.sending.equals((Object)type)) {
            this.myProgress.setText2(SvnBundle.message("progress.text2.sending", target));
        } else if (CommitEventType.replacing.equals((Object)type)) {
            this.myProgress.setText2(SvnBundle.message("progress.text2.replacing", target));
        } else if (CommitEventType.transmittingDeltas.equals((Object)type)) {
            this.myProgress.setText2(SvnBundle.message("progress.text2.transmitting.delta", target));
        }
    }

    private void trackDeletedFile(@NotNull ProgressEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/svn/checkin/IdeaCommitHandler", "trackDeletedFile"));
        }
        String filePath = "file://" + event.getFile().getAbsolutePath().replace(File.separatorChar, '/');
        VirtualFile virtualFile = (VirtualFile)ReadAction.compute(() -> VirtualFileManager.getInstance().findFileByUrl(filePath));
        if (virtualFile != null) {
            this.myDeletedFiles.add(virtualFile);
        }
    }

    @NotNull
    private static CommitEventType convert(@NotNull EventAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "org/jetbrains/idea/svn/checkin/IdeaCommitHandler", "convert"));
        }
        CommitEventType result = CommitEventType.unknown;
        if (EventAction.COMMIT_ADDED.equals((Object)action)) {
            result = CommitEventType.adding;
        } else if (EventAction.COMMIT_DELETED.equals((Object)action)) {
            result = CommitEventType.deleting;
        } else if (EventAction.COMMIT_MODIFIED.equals((Object)action)) {
            result = CommitEventType.sending;
        } else if (EventAction.COMMIT_REPLACED.equals((Object)action)) {
            result = CommitEventType.replacing;
        } else if (EventAction.COMMIT_DELTA_SENT.equals((Object)action)) {
            result = CommitEventType.transmittingDeltas;
        } else if (EventAction.SKIP.equals((Object)action)) {
            result = CommitEventType.skipped;
        } else if (EventAction.FAILED_OUT_OF_DATE.equals((Object)action)) {
            result = CommitEventType.failedOutOfDate;
        }
        if (CommitEventType.unknown.equals((Object)result)) {
            LOG.warn("Could not create commit event from action " + (Object)((Object)action));
        }
        CommitEventType commitEventType = result;
        if (commitEventType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/checkin/IdeaCommitHandler", "convert"));
        }
        return commitEventType;
    }
}

