/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.diff;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.diff.ElementWithBranchComparer;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class DirectoryWithBranchComparer
extends ElementWithBranchComparer {
    @NotNull
    private final StringBuilder titleBuilder;
    @NotNull
    private final List<Change> changes;

    public DirectoryWithBranchComparer(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull String branchUrl, long branchRevision) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/diff/DirectoryWithBranchComparer", "<init>"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "org/jetbrains/idea/svn/diff/DirectoryWithBranchComparer", "<init>"));
        }
        if (branchUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchUrl", "org/jetbrains/idea/svn/diff/DirectoryWithBranchComparer", "<init>"));
        }
        super(project, virtualFile, branchUrl, branchRevision);
        this.titleBuilder = new StringBuilder();
        this.changes = new ArrayList<Change>();
    }

    @Override
    protected void compare() throws SVNException, VcsException {
        this.titleBuilder.append(SvnBundle.message("repository.browser.compare.title", this.myElementUrl, FileUtil.toSystemDependentName((String)this.myVirtualFile.getPresentableUrl())));
        SvnTarget target1 = SvnTarget.fromURL((SVNURL)this.myElementUrl);
        SvnTarget target2 = SvnTarget.fromFile((File)VfsUtilCore.virtualToIoFile((VirtualFile)this.myVirtualFile));
        this.changes.addAll(this.getClientFactory().createDiffClient().compare(target1, target2));
    }

    @NotNull
    private ClientFactory getClientFactory() {
        ClientFactory clientFactory = DirectoryWithBranchComparer.getClientFactory(this.myVcs, VfsUtilCore.virtualToIoFile((VirtualFile)this.myVirtualFile));
        if (clientFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/diff/DirectoryWithBranchComparer", "getClientFactory"));
        }
        return clientFactory;
    }

    @NotNull
    public static ClientFactory getClientFactory(@NotNull SvnVcs vcs, @NotNull File file) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/diff/DirectoryWithBranchComparer", "getClientFactory"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/diff/DirectoryWithBranchComparer", "getClientFactory"));
        }
        WorkingCopyFormat format = vcs.getWorkingCopyFormat(file);
        ClientFactory clientFactory = format.isOrGreater(WorkingCopyFormat.ONE_DOT_EIGHT) ? vcs.getCommandLineFactory() : vcs.getSvnKitFactory();
        if (clientFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/diff/DirectoryWithBranchComparer", "getClientFactory"));
        }
        return clientFactory;
    }

    @Override
    protected void onCancel() {
        this.changes.clear();
    }

    @Override
    protected void showResult() {
        AbstractVcsHelper.getInstance((Project)this.myProject).showWhatDiffersBrowser(null, this.changes, this.titleBuilder.toString());
    }

    @Override
    public String getTitle() {
        return SvnBundle.message("progress.computing.difference", new Object[0]);
    }
}

