/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.auth.SvnAuthenticationNotifier;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.LogEntryConsumer;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnCopyPathTracker;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SingleCommittedListProvider {
    private static final Logger LOG = Logger.getInstance(SingleCommittedListProvider.class);
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final VcsRevisionNumber number;
    private SvnChangeList[] changeList;
    private SVNRevision revisionBefore;
    private SVNURL repositoryUrl;
    private SVNURL svnRootUrl;
    private SvnRepositoryLocation svnRootLocation;
    private String repositoryRelativeUrl;
    private FilePath filePath;

    public SingleCommittedListProvider(@NotNull SvnVcs vcs, @NotNull VirtualFile file, @NotNull VcsRevisionNumber number) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/history/SingleCommittedListProvider", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/history/SingleCommittedListProvider", "<init>"));
        }
        if (number == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "number", "org/jetbrains/idea/svn/history/SingleCommittedListProvider", "<init>"));
        }
        this.myVcs = vcs;
        this.myProject = vcs.getProject();
        this.file = file;
        this.number = number;
    }

    public Pair<SvnChangeList, FilePath> run() throws VcsException {
        Pair result = null;
        if (this.setup()) {
            this.calculate();
            result = Pair.create((Object)this.changeList[0], (Object)this.filePath);
        }
        return result;
    }

    private boolean setup() {
        boolean result = false;
        RootUrlInfo rootUrlInfo = this.myVcs.getSvnFileUrlMapping().getWcRootForFilePath(VfsUtilCore.virtualToIoFile((VirtualFile)this.file));
        if (rootUrlInfo != null) {
            this.changeList = new SvnChangeList[1];
            this.revisionBefore = ((SvnRevisionNumber)this.number).getRevision();
            this.repositoryUrl = rootUrlInfo.getRepositoryUrlUrl();
            this.svnRootUrl = rootUrlInfo.getAbsoluteUrlAsUrl();
            this.svnRootLocation = new SvnRepositoryLocation(rootUrlInfo.getAbsoluteUrl());
            this.repositoryRelativeUrl = SvnUtil.ensureStartSlash(SvnUtil.join(SvnUtil.getRelativeUrl(this.repositoryUrl.toDecodedString(), this.svnRootUrl.toDecodedString()), SvnUtil.getRelativePath(rootUrlInfo.getPath(), this.file.getPath())));
            this.filePath = VcsUtil.getFilePath((VirtualFile)this.file);
            result = true;
        }
        return result;
    }

    private void calculate() throws VcsException {
        Change targetChange;
        ContentRevision afterRevision;
        this.filePath = !this.searchForUrl(this.svnRootUrl) && (!this.hasAccess(this.repositoryUrl) || !this.searchForUrl(this.repositoryUrl)) ? this.searchFromHead(this.svnRootUrl) : (this.changeList[0].getChanges().size() == 1 ? ((afterRevision = this.changeList[0].getChanges().iterator().next().getAfterRevision()) != null ? afterRevision.getFile() : this.filePath) : ((targetChange = this.changeList[0].getByPath(this.repositoryRelativeUrl)) == null ? this.searchFromHead(this.svnRootUrl) : this.filePath));
    }

    private boolean hasAccess(@NotNull SVNURL url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/history/SingleCommittedListProvider", "hasAccess"));
        }
        return SvnAuthenticationNotifier.passiveValidation(this.myVcs, url);
    }

    private FilePath searchFromHead(@NotNull SVNURL url) throws VcsException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/history/SingleCommittedListProvider", "searchFromHead"));
        }
        SvnCopyPathTracker pathTracker = new SvnCopyPathTracker(this.repositoryUrl.toDecodedString(), this.repositoryRelativeUrl);
        SvnTarget target = SvnTarget.fromURL((SVNURL)url);
        this.myVcs.getFactory(target).createHistoryClient().doLog(target, SVNRevision.HEAD, this.revisionBefore, false, true, false, 0L, null, logEntry -> {
            this.checkDisposed();
            if (logEntry.getDate() != null) {
                pathTracker.accept((LogEntry)logEntry);
                if (logEntry.getRevision() == this.revisionBefore.getNumber()) {
                    this.changeList[0] = this.createChangeList((LogEntry)logEntry);
                }
            }
        });
        FilePath path = pathTracker.getFilePath(this.myVcs);
        return path == null ? this.filePath : path;
    }

    @NotNull
    private SvnChangeList createChangeList(@NotNull LogEntry logEntry) {
        if (logEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logEntry", "org/jetbrains/idea/svn/history/SingleCommittedListProvider", "createChangeList"));
        }
        SvnChangeList svnChangeList = new SvnChangeList(this.myVcs, this.svnRootLocation, logEntry, this.repositoryUrl.toDecodedString());
        if (svnChangeList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SingleCommittedListProvider", "createChangeList"));
        }
        return svnChangeList;
    }

    private void checkDisposed() {
        if (this.myProject.isDisposed()) {
            throw new ProcessCanceledException();
        }
    }

    private boolean searchForUrl(@NotNull SVNURL url) throws VcsException {
        block3: {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/history/SingleCommittedListProvider", "searchForUrl"));
            }
            LogEntryConsumer handler = logEntry -> {
                this.checkDisposed();
                if (logEntry.getDate() != null) {
                    this.changeList[0] = this.createChangeList((LogEntry)logEntry);
                }
            };
            SvnTarget target = SvnTarget.fromURL((SVNURL)url);
            try {
                this.myVcs.getFactory(target).createHistoryClient().doLog(target, this.revisionBefore, this.revisionBefore, false, true, false, 1L, null, handler);
            }
            catch (SvnBindException e) {
                LOG.info((Throwable)((Object)e));
                if (e.containsCategory(160000)) break block3;
                throw e;
            }
        }
        return this.changeList[0] != null;
    }
}

