/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.integrate.BaseMergeTask;
import org.jetbrains.idea.svn.integrate.QuickMerge;

public class MergeTask
extends BaseMergeTask {
    @NotNull
    private final Runnable myCallback;

    public MergeTask(@NotNull QuickMerge mergeProcess, @NotNull Runnable callback) {
        if (mergeProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeProcess", "org/jetbrains/idea/svn/integrate/MergeTask", "<init>"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/idea/svn/integrate/MergeTask", "<init>"));
        }
        super(mergeProcess);
        this.myCallback = callback;
    }

    @Override
    public void run() throws VcsException {
        boolean needRefresh = this.setupDefaultEmptyChangeListForMerge();
        if (needRefresh) {
            ChangeListManager.getInstance((Project)this.myMergeContext.getProject()).invokeAfterUpdate(this.myCallback, InvokeAfterUpdateMode.BACKGROUND_NOT_CANCELLABLE, "", ModalityState.NON_MODAL);
        } else {
            this.myCallback.run();
        }
    }

    private boolean setupDefaultEmptyChangeListForMerge() {
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myMergeContext.getProject());
        int i = 0;
        boolean needRefresh = false;
        while (true) {
            String name;
            LocalChangeList changeList;
            if ((changeList = changeListManager.findChangeList(name = this.myMergeContext.getTitle() + (i > 0 ? " (" + i + ")" : ""))) == null) {
                changeListManager.setDefaultChangeList(changeListManager.addChangeList(name, null));
                needRefresh = true;
                break;
            }
            if (changeList.getChanges().isEmpty()) {
                if (changeList.isDefault()) break;
                changeListManager.setDefaultChangeList(changeList);
                needRefresh = true;
                break;
            }
            ++i;
        }
        return needRefresh;
    }
}

