/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.importing;

import com.intellij.openapi.externalSystem.importing.ImportSpec;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportSpecImpl
implements ImportSpec {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private ProgressExecutionMode myProgressExecutionMode;
    private boolean forceWhenUptodate;
    private boolean whenAutoImportEnabled;
    @Nullable
    private ExternalProjectRefreshCallback myCallback;
    private boolean isPreviewMode;
    private boolean createDirectoriesForEmptyContentRoots;
    private boolean isReportRefreshError;
    @Nullable
    private String myVmOptions;
    @Nullable
    private String myArguments;

    public ImportSpecImpl(@NotNull Project project, @NotNull ProjectSystemId id) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/importing/ImportSpecImpl", "<init>"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/importing/ImportSpecImpl", "<init>"));
        }
        this.myProject = project;
        this.myExternalSystemId = id;
        this.myProgressExecutionMode = ProgressExecutionMode.MODAL_SYNC;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/importing/ImportSpecImpl", "getProject"));
        }
        return project;
    }

    @Override
    @NotNull
    public ProjectSystemId getExternalSystemId() {
        ProjectSystemId projectSystemId = this.myExternalSystemId;
        if (projectSystemId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/importing/ImportSpecImpl", "getExternalSystemId"));
        }
        return projectSystemId;
    }

    @Override
    @NotNull
    public ProgressExecutionMode getProgressExecutionMode() {
        ProgressExecutionMode progressExecutionMode = this.myProgressExecutionMode;
        if (progressExecutionMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/importing/ImportSpecImpl", "getProgressExecutionMode"));
        }
        return progressExecutionMode;
    }

    public void setProgressExecutionMode(@NotNull ProgressExecutionMode progressExecutionMode) {
        if (progressExecutionMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressExecutionMode", "com/intellij/openapi/externalSystem/importing/ImportSpecImpl", "setProgressExecutionMode"));
        }
        this.myProgressExecutionMode = progressExecutionMode;
    }

    @Override
    public boolean isForceWhenUptodate() {
        return this.forceWhenUptodate;
    }

    public void setForceWhenUptodate(boolean forceWhenUptodate) {
        this.forceWhenUptodate = forceWhenUptodate;
    }

    @Override
    public boolean whenAutoImportEnabled() {
        return this.whenAutoImportEnabled;
    }

    public void setWhenAutoImportEnabled(boolean whenAutoImportEnabled) {
        this.whenAutoImportEnabled = whenAutoImportEnabled;
    }

    public void setCallback(@Nullable ExternalProjectRefreshCallback callback) {
        this.myCallback = callback;
    }

    @Override
    @Nullable
    public ExternalProjectRefreshCallback getCallback() {
        return this.myCallback;
    }

    @Override
    public boolean isPreviewMode() {
        return this.isPreviewMode;
    }

    public void setPreviewMode(boolean isPreviewMode) {
        this.isPreviewMode = isPreviewMode;
    }

    @Override
    public boolean shouldCreateDirectoriesForEmptyContentRoots() {
        return this.createDirectoriesForEmptyContentRoots;
    }

    public void setCreateDirectoriesForEmptyContentRoots(boolean createDirectoriesForEmptyContentRoots) {
        this.createDirectoriesForEmptyContentRoots = createDirectoriesForEmptyContentRoots;
    }

    @Override
    public boolean isReportRefreshError() {
        return this.isReportRefreshError;
    }

    public void setReportRefreshError(boolean isReportRefreshError) {
        this.isReportRefreshError = isReportRefreshError;
    }

    @Override
    @Nullable
    public String getVmOptions() {
        return this.myVmOptions;
    }

    public void setVmOptions(@Nullable String vmOptions) {
        this.myVmOptions = vmOptions;
    }

    @Override
    @Nullable
    public String getArguments() {
        return this.myArguments;
    }

    public void setArguments(@Nullable String arguments) {
        this.myArguments = arguments;
    }
}

