/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListenerAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalSystemSettings<SS extends AbstractExternalSystemSettings<SS, PS, L>, PS extends ExternalProjectSettings, L extends ExternalSystemSettingsListener<PS>>
implements Disposable {
    @NotNull
    private final Topic<L> myChangesTopic;
    private Project myProject;
    @NotNull
    private final Map<String, PS> myLinkedProjectsSettings;
    @NotNull
    private final Map<String, PS> myLinkedProjectsSettingsView;

    protected AbstractExternalSystemSettings(@NotNull Topic<L> topic, @NotNull Project project) {
        if (topic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topic", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemSettings", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemSettings", "<init>"));
        }
        this.myLinkedProjectsSettings = ContainerUtilRt.newHashMap();
        this.myLinkedProjectsSettingsView = Collections.unmodifiableMap(this.myLinkedProjectsSettings);
        this.myChangesTopic = topic;
        this.myProject = project;
    }

    public void dispose() {
        this.myProject = null;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemSettings", "getProject"));
        }
        return project;
    }

    public boolean showSelectiveImportDialogOnInitialImport() {
        return SystemProperties.is((String)"external.system.show.selective.import.dialog");
    }

    public abstract void subscribe(@NotNull ExternalSystemSettingsListener<PS> var1);

    public void copyFrom(@NotNull SS settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemSettings", "copyFrom"));
        }
        for (ExternalProjectSettings projectSettings : ((AbstractExternalSystemSettings)settings).getLinkedProjectsSettings()) {
            this.myLinkedProjectsSettings.put(projectSettings.getExternalProjectPath(), projectSettings);
        }
        this.copyExtraSettingsFrom(settings);
    }

    protected abstract void copyExtraSettingsFrom(@NotNull SS var1);

    @NotNull
    public Collection<PS> getLinkedProjectsSettings() {
        Collection<PS> collection = this.myLinkedProjectsSettingsView.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemSettings", "getLinkedProjectsSettings"));
        }
        return collection;
    }

    @Nullable
    public PS getLinkedProjectSettings(@NotNull String linkedProjectPath) {
        if (linkedProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkedProjectPath", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemSettings", "getLinkedProjectSettings"));
        }
        ExternalProjectSettings ps = (ExternalProjectSettings)this.myLinkedProjectsSettings.get(linkedProjectPath);
        if (ps == null) {
            for (ExternalProjectSettings ps1 : this.myLinkedProjectsSettings.values()) {
                for (String modulePath : ps1.getModules()) {
                    if (!linkedProjectPath.equals(modulePath)) continue;
                    return (PS)ps1;
                }
            }
        }
        return (PS)ps;
    }

    public void linkProject(@NotNull PS settings) throws IllegalArgumentException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemSettings", "linkProject"));
        }
        PS existing = this.getLinkedProjectSettings(((ExternalProjectSettings)settings).getExternalProjectPath());
        if (existing != null) {
            throw new IllegalArgumentException(String.format("Can't link external project '%s'. Reason: it's already registered at the current ide project", ((ExternalProjectSettings)settings).getExternalProjectPath()));
        }
        this.myLinkedProjectsSettings.put(((ExternalProjectSettings)settings).getExternalProjectPath(), settings);
        this.getPublisher().onProjectsLinked(Collections.singleton(settings));
    }

    public boolean unlinkExternalProject(@NotNull String linkedProjectPath) {
        if (linkedProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkedProjectPath", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemSettings", "unlinkExternalProject"));
        }
        ExternalProjectSettings removed = (ExternalProjectSettings)this.myLinkedProjectsSettings.remove(linkedProjectPath);
        if (removed == null) {
            return false;
        }
        this.getPublisher().onProjectsUnlinked(Collections.singleton(linkedProjectPath));
        return true;
    }

    public void setLinkedProjectsSettings(@NotNull Collection<PS> settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemSettings", "setLinkedProjectsSettings"));
        }
        this.setLinkedProjectsSettings(settings, null);
    }

    private void setLinkedProjectsSettings(@NotNull Collection<PS> settings, @Nullable ExternalSystemSettingsListener listener) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemSettings", "setLinkedProjectsSettings"));
        }
        ArrayList added = ContainerUtilRt.newArrayList();
        HashMap removed = ContainerUtilRt.newHashMap(this.myLinkedProjectsSettings);
        this.myLinkedProjectsSettings.clear();
        for (ExternalProjectSettings current : settings) {
            this.myLinkedProjectsSettings.put(current.getExternalProjectPath(), current);
        }
        for (ExternalProjectSettings current : settings) {
            ExternalProjectSettings old = (ExternalProjectSettings)removed.remove(current.getExternalProjectPath());
            if (old == null) {
                added.add(current);
                continue;
            }
            if (current.isUseAutoImport() != old.isUseAutoImport()) {
                if (listener != null) {
                    listener.onUseAutoImportChange(current.isUseAutoImport(), current.getExternalProjectPath());
                }
                this.getPublisher().onUseAutoImportChange(current.isUseAutoImport(), current.getExternalProjectPath());
            }
            if (old.isCreateEmptyContentRootDirectories() != current.isCreateEmptyContentRootDirectories()) {
                ExternalProjectsManager.getInstance(this.getProject()).getExternalProjectsWatcher().markDirty(current.getExternalProjectPath());
            }
            this.checkSettings(old, current);
        }
        if (!added.isEmpty()) {
            if (listener != null) {
                listener.onProjectsLinked(added);
            }
            this.getPublisher().onProjectsLinked(added);
        }
        if (!removed.isEmpty()) {
            if (listener != null) {
                listener.onProjectsUnlinked(removed.keySet());
            }
            this.getPublisher().onProjectsUnlinked(removed.keySet());
        }
    }

    protected abstract void checkSettings(@NotNull PS var1, @NotNull PS var2);

    @NotNull
    public Topic<L> getChangesTopic() {
        Topic<L> topic = this.myChangesTopic;
        if (topic == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemSettings", "getChangesTopic"));
        }
        return topic;
    }

    @NotNull
    public L getPublisher() {
        ExternalSystemSettingsListener externalSystemSettingsListener = (ExternalSystemSettingsListener)this.myProject.getMessageBus().syncPublisher(this.myChangesTopic);
        if (externalSystemSettingsListener == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemSettings", "getPublisher"));
        }
        return (L)externalSystemSettingsListener;
    }

    protected void fillState(@NotNull State<PS> state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemSettings", "fillState"));
        }
        state.setLinkedExternalProjectsSettings(ContainerUtilRt.newTreeSet(this.myLinkedProjectsSettings.values()));
    }

    protected void loadState(@NotNull State<PS> state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemSettings", "loadState"));
        }
        Set<PS> settings = state.getLinkedExternalProjectsSettings();
        if (settings != null) {
            this.setLinkedProjectsSettings(settings, new ExternalSystemSettingsListenerAdapter(){

                @Override
                public void onProjectsLinked(@NotNull Collection linked) {
                    if (linked == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linked", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemSettings$1", "onProjectsLinked"));
                    }
                    for (Object o : linked) {
                        ExternalProjectSettings settings = (ExternalProjectSettings)o;
                        for (ExternalSystemManager manager : (ExternalSystemManager[])ExternalSystemManager.EP_NAME.getExtensions()) {
                            AbstractExternalSystemSettings se = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)AbstractExternalSystemSettings.this.myProject);
                            ProjectSystemId externalSystemId = manager.getSystemId();
                            if (settings != se.getLinkedProjectSettings(settings.getExternalProjectPath())) continue;
                            ExternalProjectsManager.getInstance(AbstractExternalSystemSettings.this.myProject).refreshProject(settings.getExternalProjectPath(), new ImportSpecBuilder(AbstractExternalSystemSettings.this.myProject, externalSystemId).useDefaultCallback().use(ProgressExecutionMode.IN_BACKGROUND_ASYNC).build());
                        }
                    }
                }
            });
        }
    }

    public static interface State<S> {
        public Set<S> getLinkedExternalProjectsSettings();

        public void setLinkedExternalProjectsSettings(Set<S> var1);
    }
}

