/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.GetOperation;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.RecursionType;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.TFSVcs;
import org.jetbrains.tfsIntegration.core.tfs.WorkingFolderInfo;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.Workstation;
import org.jetbrains.tfsIntegration.core.tfs.operations.ApplyGetOperations;
import org.jetbrains.tfsIntegration.core.tfs.operations.ApplyProgress;
import org.jetbrains.tfsIntegration.core.tfs.version.LatestVersionSpec;
import org.jetbrains.tfsIntegration.exceptions.OperationFailedException;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.ui.checkoutwizard.CheckoutWizard;
import org.jetbrains.tfsIntegration.ui.checkoutwizard.CheckoutWizardModel;
import org.jetbrains.tfsIntegration.ui.checkoutwizard.CheckoutWizardStep;
import org.jetbrains.tfsIntegration.ui.checkoutwizard.ChooseLocalAndServerPathsStep;
import org.jetbrains.tfsIntegration.ui.checkoutwizard.ChooseModeStep;
import org.jetbrains.tfsIntegration.ui.checkoutwizard.ChooseServerPathStep;
import org.jetbrains.tfsIntegration.ui.checkoutwizard.ChooseWorkspaceStep;
import org.jetbrains.tfsIntegration.ui.checkoutwizard.SummaryStep;

public class TFSCheckoutProvider
implements CheckoutProvider {
    public void doCheckout(@NotNull Project project, @Nullable CheckoutProvider.Listener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/tfsIntegration/core/TFSCheckoutProvider", "doCheckout"));
        }
        CheckoutWizardModel model = new CheckoutWizardModel();
        List<CheckoutWizardStep> steps = Arrays.asList(new CheckoutWizardStep[]{new ChooseModeStep(model), new ChooseWorkspaceStep(project, model), new ChooseLocalAndServerPathsStep(model), new ChooseServerPathStep(model), new SummaryStep(model)});
        CheckoutWizard w = new CheckoutWizard(project, steps, model);
        if (w.showAndGet()) {
            TFSCheckoutProvider.doCheckout(model, listener);
        }
    }

    private static void doCheckout(CheckoutWizardModel model, CheckoutProvider.Listener listener) {
        ArrayList errors = new ArrayList();
        Ref localRoot = new Ref();
        Runnable checkoutRunnable = () -> {
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            try {
                WorkspaceInfo workspace = model.getMode() == CheckoutWizardModel.Mode.Auto ? TFSCheckoutProvider.createWorkspace(model) : model.getWorkspace();
                localRoot.set((Object)workspace.findLocalPathByServerPath(model.getServerPath(), true, null));
                List<GetOperation> operations = workspace.getServer().getVCS().get(workspace.getName(), workspace.getOwnerName(), model.getServerPath(), LatestVersionSpec.INSTANCE, RecursionType.Full, null, null);
                Collection<VcsException> applyErrors = ApplyGetOperations.execute(ProjectManager.getInstance().getDefaultProject(), workspace, operations, new ApplyProgress.ProgressIndicatorWrapper(progressIndicator), null, ApplyGetOperations.DownloadMode.ALLOW);
                errors.addAll(applyErrors);
            }
            catch (TfsException e) {
                errors.add(new VcsException(e.getMessage(), (Throwable)e));
            }
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously(checkoutRunnable, "Checkout from TFS", true, ProjectManager.getInstance().getDefaultProject());
        if (errors.isEmpty()) {
            Runnable listenerNotificationRunnable = () -> {
                if (listener != null) {
                    if (errors.isEmpty()) {
                        listener.directoryCheckedOut(new File(((FilePath)localRoot.get()).getPath()), TFSVcs.getKey());
                    }
                    listener.checkoutCompleted();
                }
            };
            VirtualFile vf = VcsUtil.getVirtualFile((String)((FilePath)localRoot.get()).getPath());
            if (vf != null) {
                vf.refresh(true, true, () -> {
                    ModalityState current = ModalityState.current();
                    ApplicationManager.getApplication().invokeLater(listenerNotificationRunnable, current);
                });
            } else {
                listenerNotificationRunnable.run();
            }
        } else {
            StringBuilder errorMessage = new StringBuilder("The following errors occurred during checkout:\n\n");
            for (VcsException e : errors) {
                errorMessage.append(e.getMessage()).append("\n");
            }
            Messages.showErrorDialog((String)errorMessage.toString(), (String)TFSBundle.message("checkout.from.tfs.error.dialog.title", new Object[0]));
        }
    }

    @NonNls
    public String getVcsName() {
        return "_TFS";
    }

    private static WorkspaceInfo createWorkspace(CheckoutWizardModel model) throws TfsException {
        WorkspaceInfo workspace = new WorkspaceInfo(model.getServer(), model.getServer().getQualifiedUsername(), Workstation.getComputerName());
        workspace.setName(model.getNewWorkspaceName());
        workspace.setComment(TFSBundle.message("automatic.workspace.comment", ApplicationNamesInfo.getInstance().getFullProductName(), model.getServerPath()));
        FilePath localPath = VcsUtil.getFilePath((String)model.getDestinationFolder(), (boolean)true);
        WorkingFolderInfo workingFolder = new WorkingFolderInfo(WorkingFolderInfo.Status.Active, localPath, model.getServerPath());
        workspace.addWorkingFolderInfo(workingFolder);
        try {
            workspace.saveToServer(null, null);
        }
        catch (TfsException e) {
            String errorMessage = MessageFormat.format("Cannot create workspace ''{0}''. {1}", workspace.getName(), e.getMessage());
            throw new OperationFailedException(errorMessage);
        }
        return workspace;
    }
}

