/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.configuration;

import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.PublicMethodBasedOptionDescription;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.configuration.TFSConfigurationManager;
import org.jetbrains.tfsIntegration.core.configuration.TfsCheckinPoliciesCompatibility;

public final class TFSOptionsTopHitProvider
extends OptionsTopHitProvider {
    public String getId() {
        return "vcs";
    }

    @NotNull
    public Collection<OptionDescription> getOptions(@Nullable Project project) {
        if (project != null) {
            for (VcsDescriptor descriptor : ProjectLevelVcsManager.getInstance((Project)project).getAllVcss()) {
                if (!"TFS".equals(descriptor.getDisplayName())) continue;
                Collection<BooleanOptionDescription> collection = Collections.unmodifiableCollection(Arrays.asList(new BooleanOptionDescription[]{new Option("TFS: Use HTTP Proxy settings", null, "useIdeaHttpProxy", "setUseIdeaHttpProxy"), new Option("TFS: Evaluate Team Explorer policies", "teamExplorer", null, "setSupportTfsCheckinPolicies"), new Option("TFS: Evaluate Teamprise policies", "teamprise", null, "setSupportStatefulCheckinPolicies"), new Option("TFS: Warn about not installed policies", "nonInstalled", null, "setReportNotInstalledCheckinPolicies")}));
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/configuration/TFSOptionsTopHitProvider", "getOptions"));
                }
                return collection;
            }
        }
        List<OptionDescription> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/configuration/TFSOptionsTopHitProvider", "getOptions"));
        }
        return list;
    }

    private static final class Option
    extends PublicMethodBasedOptionDescription {
        private final String myField;

        Option(String option, String field, String getterName, String setterName) {
            super(option, "vcs.TFS", getterName, setterName);
            this.myField = field;
        }

        public TFSConfigurationManager getInstance() {
            return TFSConfigurationManager.getInstance();
        }

        public boolean isOptionEnabled() {
            if (this.myField == null) {
                return super.isOptionEnabled();
            }
            try {
                TfsCheckinPoliciesCompatibility instance = this.getInstance().getCheckinPoliciesCompatibility();
                Field field = instance.getClass().getField(this.myField);
                return field.getBoolean(instance);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            return false;
        }
    }
}

