/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.net.HttpConfigurable;
import java.awt.Component;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.configuration.Credentials;
import org.jetbrains.tfsIntegration.core.configuration.TFSConfigurationManager;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;
import org.jetbrains.tfsIntegration.ui.TfsLoginForm;

public class TfsLoginDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)TfsLoginDialog.class.getName());
    private TfsLoginForm myLoginForm;
    private String lastMessage;
    @Nullable
    private Condition<TfsLoginDialog> myOkActionCallback;

    public TfsLoginDialog(Project project, URI initialUri, Credentials initialCredentials, boolean allowAddressChange, @Nullable Condition<TfsLoginDialog> okActionCallback) {
        super(project, true);
        this.doInit(initialUri, initialCredentials, allowAddressChange, okActionCallback);
    }

    public TfsLoginDialog(JComponent parentComponent, URI initialUri, Credentials initialCredentials, boolean allowAddressChange, @Nullable Condition<TfsLoginDialog> okActionCallback) {
        super((Component)parentComponent, true);
        this.doInit(initialUri, initialCredentials, allowAddressChange, okActionCallback);
    }

    private void doInit(URI initialUri, Credentials initialCredentials, boolean allowAddressChange, Condition<TfsLoginDialog> okActionCallback) {
        this.myOkActionCallback = okActionCallback;
        this.setTitle(TFSBundle.message(allowAddressChange ? "logindialog.title.connect" : "logindialog.title.login", new Object[0]));
        this.myLoginForm = new TfsLoginForm(initialUri, initialCredentials, allowAddressChange);
        this.myLoginForm.addListener(e -> {
            this.lastMessage = null;
            this.setOKActionEnabled(true);
        });
        this.init();
    }

    protected JComponent createCenterPanel() {
        return this.myLoginForm.getContentPane();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myLoginForm.getPreferredFocusedComponent();
    }

    public URI getUri() {
        URI uri = TfsUtil.getUrl(this.myLoginForm.getUrl(), false, false);
        LOG.assertTrue(uri != null);
        return uri;
    }

    public Credentials getCredentials() {
        return this.myLoginForm.getCredentials();
    }

    public void setMessage(@Nullable String message) {
        if (message != null && !message.endsWith(".")) {
            message = message + ".";
        }
        this.lastMessage = message;
        this.setErrorText(this.lastMessage);
        this.setOKActionEnabled(this.lastMessage == null);
    }

    @NotNull
    public List<ValidationInfo> doValidateAll() {
        List<ValidationInfo> list = this.lastMessage != null ? Collections.singletonList(new ValidationInfo(this.lastMessage, null)) : this.myLoginForm.validate();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/TfsLoginDialog", "doValidateAll"));
        }
        return list;
    }

    protected String getDimensionServiceKey() {
        return "TFS.Login";
    }

    protected void doOKAction() {
        if (TfsLoginDialog.shouldPromptForProxyPassword(false)) {
            HttpConfigurable hc = HttpConfigurable.getInstance();
            hc.setPlainProxyPassword(this.myLoginForm.getProxyPassword());
        }
        if (this.myLoginForm.getCredentials().getType() == Credentials.Type.Alternate && "http".equals(this.getUri().getScheme()) && Messages.showYesNoDialog((Component)this.myLoginForm.getContentPane(), (String)"You're about to send your credentials over unsecured HTTP connection. Continue?", (String)this.getTitle(), null) != 0) {
            return;
        }
        if (this.myOkActionCallback == null || this.myOkActionCallback.value((Object)this)) {
            super.doOKAction();
        }
    }

    public static boolean shouldPromptForProxyPassword(boolean strictOnly) {
        HttpConfigurable hc = HttpConfigurable.getInstance();
        return TFSConfigurationManager.getInstance().useIdeaHttpProxy() && hc.USE_HTTP_PROXY && hc.PROXY_AUTHENTICATION && !hc.KEEP_PROXY_PASSWORD && (!strictOnly || StringUtil.isEmpty((String)hc.getPlainProxyPassword()));
    }
}

