/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui.checkoutwizard;

import com.intellij.ide.wizard.AbstractWizardStepEx;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.ui.checkoutwizard.CheckoutWizardModel;
import org.jetbrains.tfsIntegration.ui.checkoutwizard.CheckoutWizardStep;
import org.jetbrains.tfsIntegration.ui.checkoutwizard.ChooseWorkspaceStep;
import org.jetbrains.tfsIntegration.ui.checkoutwizard.LocalAndServerPathsForm;
import org.jetbrains.tfsIntegration.ui.checkoutwizard.SummaryStep;

public class ChooseLocalAndServerPathsStep
extends CheckoutWizardStep {
    public static final Object ID = new Object();
    private final LocalAndServerPathsForm myPathsForm = new LocalAndServerPathsForm();

    public ChooseLocalAndServerPathsStep(CheckoutWizardModel model) {
        super("Choose Source and Destination Paths", model);
        Disposer.register((Disposable)this, (Disposable)this.myPathsForm);
        this.myPathsForm.addListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ChooseLocalAndServerPathsStep.this.updateMessage();
                ChooseLocalAndServerPathsStep.this.fireStateChanged();
            }
        });
    }

    @NotNull
    public Object getStepId() {
        Object object = ID;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/checkoutwizard/ChooseLocalAndServerPathsStep", "getStepId"));
        }
        return object;
    }

    @Nullable
    public Object getNextStepId() {
        return SummaryStep.ID;
    }

    @Nullable
    public Object getPreviousStepId() {
        return ChooseWorkspaceStep.ID;
    }

    public boolean isComplete() {
        if (ChooseLocalAndServerPathsStep.validateLocalPath(this.myPathsForm.getLocalPath()) != null) {
            return false;
        }
        return ChooseLocalAndServerPathsStep.validateServerPath(this.myPathsForm.getServerPath()) == null;
    }

    public JComponent getComponent() {
        return this.myPathsForm.getContentPanel();
    }

    public void _init() {
        this.myPathsForm.initialize(this.myModel.getServer(), this.myModel.getServerPath());
        this.updateMessage();
    }

    public void commit(AbstractWizardStepEx.CommitType commitType) throws CommitStepException {
        if (ChooseLocalAndServerPathsStep.validateLocalPath(this.myPathsForm.getLocalPath()) == null) {
            this.myModel.setDestinationFolder(this.myPathsForm.getLocalPath());
        }
        if (ChooseLocalAndServerPathsStep.validateServerPath(this.myPathsForm.getServerPath()) == null) {
            this.myModel.setServerPath(this.myPathsForm.getServerPath());
        }
    }

    @Nullable
    private static String validateLocalPath(String path) {
        if (StringUtil.isEmpty((String)path)) {
            return TFSBundle.message("destination.path.not.specified", new Object[0]);
        }
        VirtualFile file = (VirtualFile)WriteAction.compute(() -> LocalFileSystem.getInstance().refreshAndFindFileByPath(path));
        if (file != null && file.exists() && !file.isDirectory()) {
            return TFSBundle.message("destination.path.is.not.a.file", new Object[0]);
        }
        return null;
    }

    @Nullable
    private static String validateServerPath(String path) {
        if (StringUtil.isEmpty((String)path)) {
            return TFSBundle.message("source.path.is.empty", new Object[0]);
        }
        return null;
    }

    private void updateMessage() {
        String errorMessage = ChooseLocalAndServerPathsStep.validateServerPath(this.myPathsForm.getServerPath());
        if (errorMessage == null) {
            errorMessage = ChooseLocalAndServerPathsStep.validateLocalPath(this.myPathsForm.getLocalPath());
        }
        if (errorMessage != null) {
            this.myPathsForm.setMessage(errorMessage, true);
        } else {
            this.myPathsForm.setMessage(TFSBundle.message("mapping.will.be.created", this.myModel.getNewWorkspaceName()), false);
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPathsForm.getPreferredFocusedComponent();
    }

    public String getHelpId() {
        return "reference.checkoutTFS.choosepaths";
    }
}

