/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui.servertree;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import java.util.Comparator;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.ui.servertree.TfsErrorTreeNode;
import org.jetbrains.tfsIntegration.ui.servertree.TfsTreeNode;

public class TfsTreeBuilder
extends AbstractTreeBuilder {
    private static final Logger LOG = Logger.getInstance((String)TfsTreeBuilder.class.getName());
    private static final Comparator<NodeDescriptor> COMPARATOR = (o1, o2) -> {
        if (o1 instanceof TfsErrorTreeNode) {
            return o2 instanceof TfsErrorTreeNode ? ((TfsErrorTreeNode)((Object)o1)).getMessage().compareTo(((TfsErrorTreeNode)((Object)o2)).getMessage()) : -1;
        }
        if (o2 instanceof TfsErrorTreeNode) {
            return 1;
        }
        TfsTreeNode n1 = (TfsTreeNode)((Object)o1);
        TfsTreeNode n2 = (TfsTreeNode)((Object)o2);
        if (n1.isDirectory() && !n2.isDirectory()) {
            return -1;
        }
        if (!n1.isDirectory() && n2.isDirectory()) {
            return 1;
        }
        return n1.getFileName().compareToIgnoreCase(n2.getFileName());
    };

    public static TfsTreeBuilder createInstance(@NotNull TfsTreeNode root, @NotNull JTree tree) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/tfsIntegration/ui/servertree/TfsTreeBuilder", "createInstance"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/tfsIntegration/ui/servertree/TfsTreeBuilder", "createInstance"));
        }
        DefaultTreeModel treeModel = new DefaultTreeModel(new DefaultMutableTreeNode((Object)root));
        tree.setModel(treeModel);
        return new TfsTreeBuilder(tree, treeModel, (AbstractTreeStructure)new SimpleTreeStructure.Impl(root){

            public boolean isToBuildChildrenInBackground(Object element) {
                return true;
            }

            public boolean isAlwaysLeaf(Object element) {
                if (element instanceof TfsTreeNode) {
                    return !((TfsTreeNode)((Object)element)).isDirectory();
                }
                LOG.assertTrue(element instanceof TfsErrorTreeNode);
                return true;
            }
        });
    }

    public TfsTreeBuilder(JTree tree, DefaultTreeModel treeModel, AbstractTreeStructure treeStructure) {
        super(tree, treeModel, treeStructure, COMPARATOR);
    }

    protected void runBackgroundLoading(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "org/jetbrains/tfsIntegration/ui/servertree/TfsTreeBuilder", "runBackgroundLoading"));
        }
        if (this.isDisposed()) {
            return;
        }
        runnable.run();
    }

    protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        if (nodeDescriptor instanceof TfsErrorTreeNode) {
            return true;
        }
        if (nodeDescriptor instanceof TfsTreeNode) {
            return !((TfsTreeNode)nodeDescriptor).isDirectory() || ((TfsTreeNode)nodeDescriptor).isRoot();
        }
        return false;
    }

    protected boolean isAlwaysShowPlus(NodeDescriptor descriptor) {
        if (descriptor instanceof TfsTreeNode) {
            return ((TfsTreeNode)descriptor).isDirectory();
        }
        LOG.assertTrue(descriptor instanceof TfsErrorTreeNode);
        return false;
    }
}

