/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.settings;

import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.security.GenericLocalPermission;
import org.lobobrowser.store.StorageManager;

class ManagedStoreSettings
implements Serializable {
    private static final Logger logger = Logger.getLogger(ManagedStoreSettings.class.getName());
    private static final ManagedStoreSettings instance;
    private static final long serialVersionUID = 22574500000020705L;

    private ManagedStoreSettings() {
    }

    public static ManagedStoreSettings getInstance() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GenericLocalPermission.EXT_GENERIC);
        }
        return instance;
    }

    public void save() {
        try {
            StorageManager.getInstance().saveSettings(this.getClass().getSimpleName(), this);
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Unable to save settings: " + this.getClass().getSimpleName(), ioe);
        }
    }

    static {
        ManagedStoreSettings ins = null;
        try {
            ins = (ManagedStoreSettings)StorageManager.getInstance().retrieveSettings(ManagedStoreSettings.class.getSimpleName(), ManagedStoreSettings.class.getClassLoader());
        }
        catch (Exception err) {
            logger.log(Level.WARNING, "getInstance(): Unable to retrieve settings.", err);
        }
        if (ins == null) {
            ins = new ManagedStoreSettings();
        }
        instance = ins;
    }
}

