/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.fileDependency;

import com.intellij.javascript.trace.execution.Utils;
import com.intellij.javascript.trace.execution.fileDependency.RuntimeDependencyEdge;
import com.intellij.lang.javascript.ui.FileColor;
import com.intellij.lang.javascript.ui.NodeModuleNamesUtil;
import com.intellij.util.containers.HashSet;
import java.awt.Color;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FileNode {
    @NotNull
    private final String myId;
    @NotNull
    private final String myUrl;
    private HashSet<RuntimeDependencyEdge> myOutgoingEdges;
    private HashSet<RuntimeDependencyEdge> myIncomingEdges;
    private final HashSet<Long> myEventsUsedIn;

    public FileNode(@NotNull String fileId, @NotNull String fileUrl) {
        if (fileId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileId", "com/intellij/javascript/trace/execution/fileDependency/FileNode", "<init>"));
        }
        if (fileUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileUrl", "com/intellij/javascript/trace/execution/fileDependency/FileNode", "<init>"));
        }
        this.myOutgoingEdges = new HashSet();
        this.myIncomingEdges = new HashSet();
        this.myEventsUsedIn = new HashSet();
        this.myId = fileId;
        this.myUrl = fileUrl;
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/fileDependency/FileNode", "getId"));
        }
        return string;
    }

    @NotNull
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/fileDependency/FileNode", "getUrl"));
        }
        return string;
    }

    public void addOutgoingEdge(@NotNull RuntimeDependencyEdge edge) {
        if (edge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/intellij/javascript/trace/execution/fileDependency/FileNode", "addOutgoingEdge"));
        }
        this.myOutgoingEdges.add((Object)edge);
    }

    public void addIncomingEdge(@NotNull RuntimeDependencyEdge edge) {
        if (edge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/intellij/javascript/trace/execution/fileDependency/FileNode", "addIncomingEdge"));
        }
        this.myIncomingEdges.add((Object)edge);
    }

    @NotNull
    public RuntimeDependencyEdge[] getOutgoingEdges() {
        RuntimeDependencyEdge[] runtimeDependencyEdgeArray = (RuntimeDependencyEdge[])this.myOutgoingEdges.toArray((Object[])new RuntimeDependencyEdge[this.myOutgoingEdges.size()]);
        if (runtimeDependencyEdgeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/fileDependency/FileNode", "getOutgoingEdges"));
        }
        return runtimeDependencyEdgeArray;
    }

    @NotNull
    public RuntimeDependencyEdge[] getIncomingEdges() {
        RuntimeDependencyEdge[] runtimeDependencyEdgeArray = (RuntimeDependencyEdge[])this.myIncomingEdges.toArray((Object[])new RuntimeDependencyEdge[this.myIncomingEdges.size()]);
        if (runtimeDependencyEdgeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/fileDependency/FileNode", "getIncomingEdges"));
        }
        return runtimeDependencyEdgeArray;
    }

    @NotNull
    public Color getFileColor() {
        Color color = FileColor.getColor((String)this.getUrl());
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/fileDependency/FileNode", "getFileColor"));
        }
        return color;
    }

    @NotNull
    public Icon getFileIcon() {
        Icon icon = FileColor.getIcon((String)this.getUrl());
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/fileDependency/FileNode", "getFileIcon"));
        }
        return icon;
    }

    @NotNull
    public String getShortFileName() {
        String string = Utils.getShortFileName(this.getUrl());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/fileDependency/FileNode", "getShortFileName"));
        }
        return string;
    }

    @NotNull
    public String getNodeModule() {
        String string = NodeModuleNamesUtil.getModule((String)this.getUrl());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/fileDependency/FileNode", "getNodeModule"));
        }
        return string;
    }

    public boolean isUsedInEvent(long eventId) {
        return this.myEventsUsedIn.contains((Object)eventId);
    }

    public void usedInEvent(long eventId) {
        this.myEventsUsedIn.add((Object)eventId);
    }
}

