/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action.mq;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgNameWithHashInfo;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.action.mq.HgMqAppliedPatchAction;
import org.zmlx.hg4idea.action.mq.HgShowUnAppliedPatchesAction;
import org.zmlx.hg4idea.command.mq.HgQGotoCommand;
import org.zmlx.hg4idea.command.mq.HgQPopCommand;
import org.zmlx.hg4idea.repo.HgRepository;

public class HgQGotoFromLogAction
extends HgMqAppliedPatchAction {
    protected void actionPerformed(final @NotNull HgRepository repository, @NotNull VcsFullCommitDetails commit) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/action/mq/HgQGotoFromLogAction", "actionPerformed"));
        }
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "org/zmlx/hg4idea/action/mq/HgQGotoFromLogAction", "actionPerformed"));
        }
        final Project project = repository.getProject();
        List parents = commit.getParents();
        Hash parentHash = parents.isEmpty() ? null : (Hash)parents.get(0);
        final HgNameWithHashInfo parentPatchName = (HgNameWithHashInfo)ContainerUtil.find(repository.getMQAppliedPatches(), info -> info.getHash().equals(parentHash));
        new Task.Backgroundable(repository.getProject(), parentPatchName != null ? HgVcsMessages.message("hg4idea.mq.progress.goto", parentPatchName) : HgVcsMessages.message("hg4idea.mq.progress.pop", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/zmlx/hg4idea/action/mq/HgQGotoFromLogAction$1", "run"));
                }
                if (parentPatchName != null) {
                    new HgQGotoCommand(repository).executeInCurrentThread(parentPatchName.getName());
                } else {
                    new HgQPopCommand(repository).executeInCurrentThread();
                }
            }

            public void onSuccess() {
                HgShowUnAppliedPatchesAction.showUnAppliedPatches(project, repository);
            }
        }.queue();
    }

    protected void actionPerformed(@NotNull HgRepository repository, @NotNull Hash commit) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/action/mq/HgQGotoFromLogAction", "actionPerformed"));
        }
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "org/zmlx/hg4idea/action/mq/HgQGotoFromLogAction", "actionPerformed"));
        }
        throw new UnsupportedOperationException();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/zmlx/hg4idea/action/mq/HgQGotoFromLogAction", "actionPerformed"));
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VcsLog log = (VcsLog)e.getRequiredData(VcsLogDataKeys.VCS_LOG);
        log.requestSelectedDetails(selectedDetails -> {
            VcsFullCommitDetails fullCommitDetails = (VcsFullCommitDetails)ContainerUtil.getFirstItem((List)selectedDetails);
            assert (fullCommitDetails != null);
            HgRepository repository = this.getRepositoryForRoot(project, fullCommitDetails.getRoot());
            assert (repository != null);
            this.actionPerformed(repository, fullCommitDetails);
        });
    }
}

