/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.util;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.util.HgUtil;

public final class HgErrorUtil {
    private static final Logger LOG = Logger.getInstance((String)HgErrorUtil.class.getName());
    private static final String SETTINGS_LINK = "settings";
    public static final String MAPPING_ERROR_MESSAGE = "Please, ensure that your project base dir is hg root directory or specify full repository path in  <a href='settings'>directory mappings panel</a>.";
    private static final String MERGE_WITH_ANCESTOR_ERROR = "merging with a working directory ancestor has no effect";
    private static final String NOTHING_TO_REBASE_WARNING = "nothing to rebase";

    private HgErrorUtil() {
    }

    public static boolean isAbort(@Nullable HgCommandResult result) {
        return result == null || HgErrorUtil.getAbortLine(result) != null;
    }

    @Nullable
    private static String getAbortLine(@NotNull HgCommandResult result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/zmlx/hg4idea/util/HgErrorUtil", "getAbortLine"));
        }
        List<String> errorLines = result.getErrorLines();
        return (String)ContainerUtil.find(errorLines, s -> HgErrorUtil.isAbortLine(s));
    }

    public static boolean isAncestorMergeError(@Nullable HgCommandResult result) {
        if (result == null) {
            return false;
        }
        String errorLine = HgErrorUtil.getAbortLine(result);
        return errorLine != null && StringUtil.contains((CharSequence)errorLine, (CharSequence)MERGE_WITH_ANCESTOR_ERROR);
    }

    public static boolean isNothingToRebase(@Nullable HgCommandResult result) {
        if (result == null) {
            return false;
        }
        return ContainerUtil.exists(result.getOutputLines(), s -> StringUtil.contains((CharSequence)s, (CharSequence)NOTHING_TO_REBASE_WARNING));
    }

    public static boolean isAuthorizationError(@Nullable HgCommandResult result) {
        if (result == null) {
            return false;
        }
        String line = HgErrorUtil.getLastErrorLine(result);
        return HgErrorUtil.isAuthorizationError(line);
    }

    @Nullable
    private static String getLastErrorLine(@Nullable HgCommandResult result) {
        if (result == null) {
            return null;
        }
        List<String> errorLines = result.getErrorLines();
        if (errorLines.isEmpty()) {
            return null;
        }
        return errorLines.get(errorLines.size() - 1);
    }

    public static boolean hasErrorsInCommandExecution(@Nullable HgCommandResult result) {
        return HgErrorUtil.isAbort(result) || result.getExitValue() != 0;
    }

    public static boolean isCommandExecutionFailed(@Nullable HgCommandResult result) {
        return HgErrorUtil.isAbort(result) || result.getExitValue() > 1;
    }

    public static boolean hasAuthorizationInDestinationPath(@Nullable String destinationPath) {
        if (StringUtil.isEmptyOrSpaces((String)destinationPath)) {
            return false;
        }
        return HgUtil.URL_WITH_PASSWORD.matcher(destinationPath).matches();
    }

    @NotNull
    public static NotificationListener getMappingErrorNotificationListener(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/util/HgErrorUtil", "getMappingErrorNotificationListener"));
        }
        NotificationListener.Adapter adapter = new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "org/zmlx/hg4idea/util/HgErrorUtil$1", "hyperlinkActivated"));
                }
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/zmlx/hg4idea/util/HgErrorUtil$1", "hyperlinkActivated"));
                }
                if (HgErrorUtil.SETTINGS_LINK.equals(e.getDescription())) {
                    ShowSettingsUtil.getInstance().showSettingsDialog(project, VcsBundle.message((String)"version.control.main.configurable.name", (Object[])new Object[0]));
                }
            }
        };
        if (adapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgErrorUtil", "getMappingErrorNotificationListener"));
        }
        return adapter;
    }

    public static boolean isUnknownEncodingError(@Nullable HgCommandResult result) {
        if (result == null) {
            return false;
        }
        List<String> errorLines = result.getErrorLines();
        if (errorLines.isEmpty()) {
            return false;
        }
        String line = errorLines.get(0);
        return !StringUtil.isEmptyOrSpaces((String)line) && line.contains("abort") && line.contains("unknown encoding");
    }

    public static boolean hasUncommittedChangesConflict(@Nullable HgCommandResult result) {
        if (result == null) {
            return false;
        }
        Pattern UNCOMMITTED_PATTERN = Pattern.compile(".*abort.*uncommitted\\s*(change|merge).*", 32);
        Matcher matcher = UNCOMMITTED_PATTERN.matcher(result.getRawError());
        return matcher.matches();
    }

    public static boolean isAuthorizationError(String line) {
        return !StringUtil.isEmptyOrSpaces((String)line) && (line.contains("authorization required") || line.contains("authorization failed"));
    }

    public static boolean isAbortLine(String line) {
        return !StringUtil.isEmptyOrSpaces((String)line) && line.trim().startsWith("abort:");
    }

    public static void handleException(@Nullable Project project, @NotNull Exception e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/zmlx/hg4idea/util/HgErrorUtil", "handleException"));
        }
        HgErrorUtil.handleException(project, "Error", e);
    }

    public static void handleException(@Nullable Project project, @NotNull String title, @NotNull Exception e) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/zmlx/hg4idea/util/HgErrorUtil", "handleException"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/zmlx/hg4idea/util/HgErrorUtil", "handleException"));
        }
        LOG.info((Throwable)e);
        new HgCommandResultNotifier(project).notifyError(null, title, e.getMessage());
    }

    public static void markDirtyAndHandleErrors(Project project, VirtualFile repository) {
        try {
            HgUtil.markDirectoryDirty(project, repository);
        }
        catch (InterruptedException | InvocationTargetException e) {
            HgErrorUtil.handleException(project, e);
        }
    }
}

