/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.reference.common;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.ReferenceSetBase;
import com.intellij.struts2.reference.common.BeanPropertyPathReference;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeanPropertyPathReferenceSet
extends ReferenceSetBase<BeanPropertyPathReference> {
    private final PsiClass beanClass;
    private final boolean supportsReadOnlyProperties;

    public BeanPropertyPathReferenceSet(@NotNull PsiElement psiElement, @Nullable PsiClass beanClass, boolean supportsReadOnlyProperties) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/struts2/reference/common/BeanPropertyPathReferenceSet", "<init>"));
        }
        super(psiElement);
        this.beanClass = beanClass;
        this.supportsReadOnlyProperties = supportsReadOnlyProperties;
    }

    public BeanPropertyPathReferenceSet(String text, @NotNull PsiElement element, int offset, char separator, PsiClass beanClass, boolean supportsReadOnlyProperties) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/struts2/reference/common/BeanPropertyPathReferenceSet", "<init>"));
        }
        super(text, element, offset, separator);
        this.beanClass = beanClass;
        this.supportsReadOnlyProperties = supportsReadOnlyProperties;
    }

    @NotNull
    protected BeanPropertyPathReference createReference(TextRange range, int index) {
        BeanPropertyPathReference beanPropertyPathReference = this.createBeanPropertyPathReference(range, index);
        if (beanPropertyPathReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/common/BeanPropertyPathReferenceSet", "createReference"));
        }
        return beanPropertyPathReference;
    }

    protected BeanPropertyPathReference createBeanPropertyPathReference(TextRange range, int index) {
        return new BeanPropertyPathReference(this, range, index);
    }

    @NotNull
    public BeanPropertyPathReference[] getPsiReferences() {
        BeanPropertyPathReference[] beanPropertyPathReferenceArray = (BeanPropertyPathReference[])ArrayUtil.toObjectArray((Collection)this.getReferences(), BeanPropertyPathReference.class);
        if (beanPropertyPathReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/common/BeanPropertyPathReferenceSet", "getPsiReferences"));
        }
        return beanPropertyPathReferenceArray;
    }

    @Nullable
    public PsiClass getBeanClass() {
        return this.beanClass;
    }

    public boolean isSupportsReadOnlyProperties() {
        return this.supportsReadOnlyProperties;
    }
}

