/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ws.WSBundle;
import com.intellij.ws.engines.jwsdp.JWSDPWSEngine;
import com.intellij.ws.index.FileBasedWSIndex;
import com.intellij.ws.index.WSIndexEntry;
import com.intellij.ws.inspections.AbstractWebServicesInspection;
import com.intellij.ws.utils.JavaElementVisitor;
import com.intellij.ws.xml.jaxb.JaxbMappingEngine;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class BaseWebServicesInspection
extends AbstractWebServicesInspection {
    protected boolean myIsOnTheFly;
    protected static LocalQuickFix[] EMPTY = LocalQuickFix.EMPTY_ARRAY;
    private static final HashSet<String> ourAnnotationsForExternallyBoundClasses = new HashSet();
    @NonNls
    static final String WEB_SERVICE_ANNOTATION_NAME = "WebService";
    private static final Key<CachedValue<ExternallyBoundClassContext>> ourClassContextKey = Key.create((String)"webservices.externally.bound.class");

    @NotNull
    public String getGroupDisplayName() {
        String string = WSBundle.message("webservices.inspections.group.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/inspections/BaseWebServicesInspection", "getGroupDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/inspections/BaseWebServicesInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    protected boolean isSimpleMethodInXmlTypeClass(PsiMethod method) {
        if (method.isConstructor()) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null || PropertyUtil.isSimplePropertyAccessor((PsiMethod)method)) {
            return false;
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (String)"javax.xml.bind.annotation.XmlType", (boolean)false) && !AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (String)"javax.jws.WebService", (boolean)false);
    }

    protected static ExternallyBoundClassContext getClassContext(@NotNull PsiClass containingClass) {
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/intellij/ws/inspections/BaseWebServicesInspection", "getClassContext"));
        }
        CachedValue value = (CachedValue)containingClass.getUserData(ourClassContextKey);
        if (value == null) {
            value = CachedValuesManager.getManager((Project)containingClass.getProject()).createCachedValue(() -> {
                if (containingClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/intellij/ws/inspections/BaseWebServicesInspection", "lambda$getClassContext$0"));
                }
                return CachedValueProvider.Result.create((Object)new ExternallyBoundClassContext(containingClass), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }, false);
            containingClass.putUserData(ourClassContextKey, (Object)value);
        }
        return (ExternallyBoundClassContext)value.getValue();
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder problemsHolder, boolean onTheFly) {
        if (problemsHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemsHolder", "com/intellij/ws/inspections/BaseWebServicesInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethod(PsiMethod psiMethod) {
                if (BaseWebServicesInspection.this.isNotAcceptableMember((PsiMember)psiMethod)) {
                    return;
                }
                BaseWebServicesInspection.this.checkMember(problemsHolder, (PsiMember)psiMethod);
            }

            public void visitField(PsiField psiField) {
                if (BaseWebServicesInspection.this.isNotAcceptableMember((PsiMember)psiField)) {
                    return;
                }
                BaseWebServicesInspection.this.checkMember(problemsHolder, (PsiMember)psiField);
            }

            public void visitClass(PsiClass c) {
                if (BaseWebServicesInspection.this.isNotAcceptableMember((PsiMember)c)) {
                    return;
                }
                BaseWebServicesInspection.this.doCheckClass(c, problemsHolder);
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/inspections/BaseWebServicesInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    protected abstract void checkMember(ProblemsHolder var1, PsiMember var2);

    protected abstract void doCheckClass(PsiClass var1, ProblemsHolder var2);

    static {
        ourAnnotationsForExternallyBoundClasses.addAll(JWSDPWSEngine.wsClassesSet);
        ourAnnotationsForExternallyBoundClasses.addAll(JaxbMappingEngine.mappedClassesSet);
    }

    static class ExternallyBoundClassContext {
        final boolean externallyBound;
        final boolean containingClassIsExternallyBound;
        final boolean isInterface;
        final PsiAnnotation annotation;
        private final String key;

        ExternallyBoundClassContext(PsiClass c) {
            this.key = c.getName();
            this.annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)c, (Set)ourAnnotationsForExternallyBoundClasses);
            boolean bl = this.containingClassIsExternallyBound = this.annotation != null;
            if (FileBasedWSIndex.getWsEntries(c).length == 0 && !this.containingClassIsExternallyBound) {
                this.externallyBound = false;
                this.isInterface = false;
            } else {
                this.externallyBound = true;
                this.isInterface = c.isInterface();
            }
        }

        final boolean isExternallyBound() {
            return this.externallyBound && !this.isInterface;
        }

        public WSIndexEntry[] getEntries(Module module) {
            return FileBasedWSIndex.getEntries(module, this.key);
        }
    }
}

