/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.annotations.NotNull;

public abstract class InsertAnnotationFix
implements LocalQuickFix {
    private final String annotationToInsert;

    protected InsertAnnotationFix(String _annotationToInsert) {
        this.annotationToInsert = _annotationToInsert;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/inspections/InsertAnnotationFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ws/inspections/InsertAnnotationFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ws/inspections/InsertAnnotationFix", "applyFix"));
        }
        PsiElement psiElement = descriptor.getPsiElement();
        PsiModifierList modifierList = ((PsiModifierListOwner)psiElement.getParent()).getModifierList();
        if (modifierList == null) {
            return;
        }
        PsiAnnotation psiAnnotation = JavaPsiFacade.getInstance((Project)project).getElementFactory().createAnnotationFromText(this.annotationToInsert, psiElement);
        PsiElement element = modifierList.getFirstChild();
        if (element != null) {
            modifierList.addBefore((PsiElement)psiAnnotation, element);
        } else {
            modifierList.add((PsiElement)psiAnnotation);
        }
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)modifierList);
    }
}

