/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.references;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.TextFilter;
import com.intellij.psi.filters.position.NamespaceFilter;
import com.intellij.psi.filters.position.ParentElementFilter;
import com.intellij.ws.references.MyReferenceProvider;
import com.intellij.ws.utils.WsReferenceProvidersHelper;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class WADLXmlReferenceProvider
extends MyReferenceProvider {
    @NonNls
    public static final String HREF_ATTRIBUTE_NAME = "href";
    @NonNls
    public static final String OUR_NS = "http://research.sun.com/wadl/2006/10";
    private final MyReferenceProvider pathReferenceProvider = WsReferenceProvidersHelper.getInstance().acquirePathReferenceProvider(false);

    @Override
    public ElementFilter getAttributeFilter() {
        return new ParentElementFilter((ElementFilter)new AndFilter((ElementFilter)new TextFilter("include"), (ElementFilter)new NamespaceFilter(new String[]{OUR_NS})), 2);
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{HREF_ATTRIBUTE_NAME};
    }

    @Override
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ws/references/WADLXmlReferenceProvider", "getReferencesByElement"));
        }
        PsiReference[] psiReferenceArray = this.pathReferenceProvider.getReferencesByElement(element);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/WADLXmlReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }
}

