/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity;

import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.velocity.psi.PsiUtil;
import com.intellij.velocity.psi.VtlImplicitVariable;
import com.intellij.velocity.psi.files.VtlFile;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VtlReferenceContributor
extends PsiReferenceContributor {
    public static final PsiElementPattern.Capture<PsiComment> VTLVARIABLE_COMMENT = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiComment.class).inFile((ElementPattern)PlatformPatterns.psiElement(VtlFile.class))).withText((ElementPattern)StandardPatterns.string().contains("@vtlvariable "));
    public static final PsiElementPattern.Capture<PsiComment> VTLMACROLIBRARY_COMMENT = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiComment.class).inFile((ElementPattern)PlatformPatterns.psiElement(VtlFile.class))).withText((ElementPattern)StandardPatterns.string().contains("@vtlmacrolibrary "));
    public static final PsiElementPattern.Capture<PsiComment> VELOCITY_PROPERTIES_COMMENT = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiComment.class).inFile((ElementPattern)PlatformPatterns.psiElement(VtlFile.class))).withText((ElementPattern)StandardPatterns.string().contains("@velocityproperties "));

    static boolean isSpecialComment(PsiComment comment) {
        return VTLVARIABLE_COMMENT.accepts((Object)comment) || VTLMACROLIBRARY_COMMENT.accepts((Object)comment) || VELOCITY_PROPERTIES_COMMENT.accepts((Object)comment);
    }

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/velocity/VtlReferenceContributor", "registerReferenceProviders"));
        }
        this.registerImplicitVariableProvider(registrar);
        this.registerExternalMacroLibraryProvider(registrar);
        this.registerVelocityPropertiesProvider(registrar);
    }

    private void registerImplicitVariableProvider(PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider(VTLVARIABLE_COMMENT, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/velocity/VtlReferenceContributor$1", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/velocity/VtlReferenceContributor$1", "getReferencesByElement"));
                }
                PsiReference[] psiReferenceArray = VtlReferenceContributor.getReferencesToJavaTypes(element);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/VtlReferenceContributor$1", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
        registrar.registerReferenceProvider(VTLVARIABLE_COMMENT, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/velocity/VtlReferenceContributor$2", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/velocity/VtlReferenceContributor$2", "getReferencesByElement"));
                }
                String text = element.getText();
                TextRange range = PsiUtil.findRange(text, "name=\"", "\"");
                if (range == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/VtlReferenceContributor$2", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                String name = range.substring(text);
                TextRange filePathRange = PsiUtil.findRange(text, "file=\"", "\"");
                String scopeFilePath = filePathRange == null ? null : filePathRange.substring(text);
                final VtlImplicitVariable variable = ((VtlFile)element.getContainingFile()).findImplicitVariable(name, scopeFilePath);
                if (variable == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/VtlReferenceContributor$2", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiReferenceBase<PsiComment> ref = new PsiReferenceBase<PsiComment>((PsiComment)element, TextRange.from((int)range.getStartOffset(), (int)name.length())){

                    public PsiElement resolve() {
                        return variable;
                    }

                    @NotNull
                    public Object[] getVariants() {
                        if (EMPTY_ARRAY == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/VtlReferenceContributor$2$1", "getVariants"));
                        }
                        return EMPTY_ARRAY;
                    }
                };
                SmartList result = new SmartList();
                result.add(ref);
                VtlReferenceContributor.findAndAddReferencesByElement(element, "file=\"", "\"", (Collection)result);
                PsiReference[] psiReferenceArray = result.toArray(PsiReference.EMPTY_ARRAY);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/VtlReferenceContributor$2", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
    }

    private void registerExternalMacroLibraryProvider(PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider(VTLMACROLIBRARY_COMMENT, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/velocity/VtlReferenceContributor$3", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/velocity/VtlReferenceContributor$3", "getReferencesByElement"));
                }
                SmartList result = new SmartList();
                if (VtlReferenceContributor.findAndAddReferencesByElement(element, "path=\"", "\"", (Collection)result)) {
                    VtlReferenceContributor.findAndAddReferencesByElement(element, "file=\"", "\"", (Collection)result);
                }
                PsiReference[] psiReferenceArray = result.toArray(PsiReference.EMPTY_ARRAY);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/VtlReferenceContributor$3", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
    }

    private void registerVelocityPropertiesProvider(PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider(VELOCITY_PROPERTIES_COMMENT, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/velocity/VtlReferenceContributor$4", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/velocity/VtlReferenceContributor$4", "getReferencesByElement"));
                }
                SmartList result = new SmartList();
                if (VtlReferenceContributor.findAndAddReferencesByElement(element, "path=\"", "\"", (Collection)result)) {
                    VtlReferenceContributor.findAndAddReferencesByElement(element, "runtime_root=\"", "\"", (Collection)result);
                    VtlReferenceContributor.findAndAddReferencesByElement(element, "file=\"", "\"", (Collection)result);
                }
                PsiReference[] psiReferenceArray = result.toArray(PsiReference.EMPTY_ARRAY);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/VtlReferenceContributor$4", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
    }

    private static boolean findAndAddReferencesByElement(@NotNull PsiElement element, @NotNull String startMarker, @NotNull String endMarker, @NotNull Collection<PsiReference> collection) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/velocity/VtlReferenceContributor", "findAndAddReferencesByElement"));
        }
        if (startMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startMarker", "com/intellij/velocity/VtlReferenceContributor", "findAndAddReferencesByElement"));
        }
        if (endMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endMarker", "com/intellij/velocity/VtlReferenceContributor", "findAndAddReferencesByElement"));
        }
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/velocity/VtlReferenceContributor", "findAndAddReferencesByElement"));
        }
        String text = element.getText();
        TextRange range = PsiUtil.findRange(text, startMarker, endMarker);
        if (range == null) {
            return false;
        }
        String filePath = range.substring(text);
        FileReference[] fileReferences = PsiUtil.getFileReferences(filePath, element, range.getStartOffset(), false);
        return collection.addAll(Arrays.asList(fileReferences));
    }

    public static PsiReference[] getReferencesToJavaTypes(PsiElement element) {
        String text = element.getText();
        TextRange range = VtlReferenceContributor.findTypeNameRange(text);
        if (range == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        JavaClassReferenceProvider provider = new JavaClassReferenceProvider();
        return provider.getReferencesByString(range.substring(text), element, range.getStartOffset());
    }

    @Nullable
    public static TextRange findTypeNameRange(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/velocity/VtlReferenceContributor", "findTypeNameRange"));
        }
        return PsiUtil.findRange(text, "type=\"", "\"");
    }
}

