/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.diagram.beans.wrappers;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.webflow.model.WebflowModel;
import com.intellij.util.containers.hash.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WebflowElementWrapper<T>
implements UserDataHolder {
    private final UserDataHolderBase userDataHolderBase = new UserDataHolderBase();
    protected static final String DELIMITER = ";";
    protected static final String VALUE_DELIMITER = "=";

    @NotNull
    public abstract T getElement();

    @NotNull
    public abstract String getName();

    @Nullable
    public abstract String getFqn();

    @NotNull
    public abstract List<WebflowModel> getFlowModels();

    @Nullable
    public Icon getIcon() {
        return null;
    }

    public boolean isValid() {
        return true;
    }

    public <U> U getUserData(@NotNull Key<U> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/spring/webflow/diagram/beans/wrappers/WebflowElementWrapper", "getUserData"));
        }
        return (U)this.userDataHolderBase.getUserData(key);
    }

    public <U> void putUserData(@NotNull Key<U> key, @Nullable U value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/spring/webflow/diagram/beans/wrappers/WebflowElementWrapper", "putUserData"));
        }
        this.userDataHolderBase.putUserData(key, value);
    }

    @NotNull
    protected static Map<String, String> split(@NotNull String fqn) {
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "com/intellij/spring/webflow/diagram/beans/wrappers/WebflowElementWrapper", "split"));
        }
        List strings = StringUtil.split((String)fqn, (String)DELIMITER);
        HashMap map = new HashMap();
        for (String string : strings) {
            Pair<String, String> pair = WebflowElementWrapper.getPair(string);
            if (pair == null) continue;
            map.put(pair.first, pair.second);
        }
        HashMap hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/diagram/beans/wrappers/WebflowElementWrapper", "split"));
        }
        return hashMap;
    }

    @Nullable
    private static Pair<String, String> getPair(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/spring/webflow/diagram/beans/wrappers/WebflowElementWrapper", "getPair"));
        }
        int i = str.indexOf(VALUE_DELIMITER);
        if (i > 0 && i < str.length() - 1) {
            String key = str.substring(0, i).trim();
            String value = str.substring(i + 1).trim();
            if (!StringUtil.isEmptyOrSpaces((String)key) && !StringUtil.isEmptyOrSpaces((String)value)) {
                return Pair.create((Object)key, (Object)value);
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebflowElementWrapper wrapper = (WebflowElementWrapper)o;
        if (!this.isValid() || !wrapper.isValid()) {
            return false;
        }
        return this.getElement().equals(wrapper.getElement());
    }

    public int hashCode() {
        return this.isValid() ? this.getElement().hashCode() : 0;
    }
}

