/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.console;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.process.RunnerMediator;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class BasicConsoleProcessRunner {
    private OSProcessHandler myProcessHandler;
    private volatile State myState = State.STARTING;
    private final LanguageConsoleView myConsoleView;
    private Executor myExecutor;
    private RunContentDescriptor myCurrentContentDescriptor;

    public abstract String getHistoryId();

    public abstract String getHistoryPersistenceId();

    public BasicConsoleProcessRunner(LanguageConsoleView consoleView) {
        this.myConsoleView = consoleView;
    }

    public boolean runProcess(@NotNull String command) throws ExecutionException {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/play/console/BasicConsoleProcessRunner", "runProcess"));
        }
        this.myState = State.EXECUTING;
        this.myProcessHandler = this.createProcessHandler(this.createCommandLine(command));
        ProcessTerminatedListener.attach((ProcessHandler)this.myProcessHandler);
        this.getConsoleView().attachToProcess((ProcessHandler)this.myProcessHandler);
        RunContentDescriptor contentDescriptor = this.getContentDescriptor();
        contentDescriptor.setProcessHandler((ProcessHandler)this.myProcessHandler);
        this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                BasicConsoleProcessRunner.this.myState = State.READY;
            }
        });
        ExecutionManager.getInstance((Project)this.getConsoleView().getProject()).getContentManager().showRunContent(this.getExecutor(), contentDescriptor);
        this.myProcessHandler.startNotify();
        return true;
    }

    protected RunContentDescriptor createContentDescriptor() {
        return new RunContentDescriptor((ExecutionConsole)this.getConsoleView(), (ProcessHandler)this.myProcessHandler, this.getConsoleComponent(), this.getConsoleView().getTitle()){

            public boolean isContentReuseProhibited() {
                return true;
            }
        };
    }

    protected JComponent getConsoleComponent() {
        return this.getConsoleView().getComponent();
    }

    @NotNull
    protected Executor createExecutor() {
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        if (executor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/console/BasicConsoleProcessRunner", "createExecutor"));
        }
        return executor;
    }

    @NotNull
    protected abstract GeneralCommandLine createCommandLine(@NotNull String var1);

    public LanguageConsoleView getConsoleView() {
        return this.myConsoleView;
    }

    @NotNull
    protected Process createProcess(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/play/console/BasicConsoleProcessRunner", "createProcess"));
        }
        ProcessHandler process = RunnerMediator.getInstance().createProcess(commandLine);
        Process process2 = ((OSProcessHandler)process).getProcess();
        if (process2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/console/BasicConsoleProcessRunner", "createProcess"));
        }
        return process2;
    }

    protected OSProcessHandler createProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/play/console/BasicConsoleProcessRunner", "createProcessHandler"));
        }
        return new RunnerMediator.CustomDestroyProcessHandler(this.createProcess(commandLine), commandLine);
    }

    public Executor getExecutor() {
        if (this.myExecutor == null) {
            this.myExecutor = this.createExecutor();
        }
        return this.myExecutor;
    }

    @NotNull
    public RunContentDescriptor getContentDescriptor() {
        if (this.myCurrentContentDescriptor == null) {
            this.myCurrentContentDescriptor = this.createContentDescriptor();
        }
        RunContentDescriptor runContentDescriptor = this.myCurrentContentDescriptor;
        if (runContentDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/console/BasicConsoleProcessRunner", "getContentDescriptor"));
        }
        return runContentDescriptor;
    }

    public State getState() {
        return this.myState;
    }

    public boolean isReady() {
        return this.getState() != State.EXECUTING;
    }

    public OSProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    public static enum State {
        STARTING,
        READY,
        COMPLETING,
        GETTING_DOCUMENTATION,
        EXECUTING;

    }
}

