/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit;

import java.io.File;
import java.nio.charset.Charset;

public final class Constants {
    public static final boolean CLR = "true".equals(System.getProperty("yourkit.clr", ""));
    public static final String SNAPSHOT_FILE_EXTENSION = ".snapshot";
    public static final String HPROF_SNAPSHOT_FILE_EXTENSION = ".hprof";
    public static final String SNAPSHOT_INDEX_POSTFIX = ".index";
    public static final File USER_HOME_RAW = new File(System.getProperty("user.home"));
    public static final File USER_HOME;
    public static final File SNAPSHOT_DIR;
    public static final File APP_SETTINGS_DIR;
    public static final File CONFIG_DIR;
    public static final File TRACING_SETTINGS_FILE;
    public static final File SAMPLING_SETTINGS_FILE;
    public static final File PREFERRED_SNAPSHOT_DIR_FILE;
    public static final String OS;
    public static final boolean OS_WINDOWS;
    public static final boolean OS_LINUX;
    public static final boolean OS_SOLARIS;
    public static final boolean OS_MAC;
    public static final boolean OS_FREEBSD;
    public static final boolean OS_HPUX;
    public static final boolean OS_AIX;
    public static final String ARCH;
    public static final boolean ARCH_AMD64;
    public static final boolean ARCH_ARM_32;
    public static final boolean ARCH_ARM_64;
    public static final boolean ARCH_PPC64LE;
    public static final boolean ARCH_PPC;
    public static final String JAVA_VERSION;
    public static final boolean JAVA_VERSION_6_OR_NEWER;
    public static final boolean JAVA_VERSION_7_OR_NEWER;
    public static final String LINE_SEPARATOR;
    public static final String PROP_JAVA_VERSION = "java.version";
    public static final String PROP_JAVA_VENDOR = "java.vendor";
    public static final boolean DEMO;
    public static final String APP_SHORT_NAME = "YourKit Java Profiler";
    public static final String APP_FULL_NAME;
    public static final String APP_RELEASE_NAME = "YourKit Java Profiler 2016.02";
    public static final String MESSAGE_DLG_TITLE;
    public static final String ERROR_DLG_TITLE;
    public static final String WARNING_DLG_TITLE;
    public static final String INTERNAL_ERROR_DLG_TITLE;
    public static final int[] DEFAULT_PORTS;
    public static final String NATIVE_METHOD_PREFIX = "$$YJP$$";
    public static final String BUILD_TIME_STAMP = "201610051703";
    public static final String PROP_JVM_NAME = "java.vm.name";
    public static final String PROP_JVM_VERSION = "java.vm.version";
    public static final String PROP_JVM_VENDOR = "java.vm.vendor";
    public static final String PROP_JVM_INPUT_ARGUMENTS = "yjp.input.arguments";
    public static final String PROP_JVM_CLASS_PATH = "java.class.path";
    public static final String PROP_JVM_LIBRARY_PATH = "java.library.path";
    public static final String PROP_JVM_BOOT_CLASS_PATH = "yjp.boot.class.path";
    public static final String PROP_CLR_VERSION = "yjp.clr.version";
    public static final String PROP_SILVERLIGHT_VERSION = "yjp.silverlight.version";
    public static final String PROP_COMMAND_LINE = "yjp.command.line";
    public static final String PROP_OS_NAME = "os.name";
    public static final String PROP_OS_NAME_YJP = "os.name.yjp";
    public static final String PROP_OS_ARCH = "os.arch";
    public static final String PROP_OS_VERSION = "os.version";
    public static final String PROP_OS_VERSION_YJP = "os.version.yjp";
    public static final String PROP_START_TIME_MS = "yjp.vm.starttime";
    public static final String PROP_COLLECTOR_NAME_PREFIX = "collector.name.";
    public static final String PROP_MEM_POOL_NAME_PREFIX = "mem.pool.name.";
    public static final String PROP_MEM_POOL_TYPE_PREFIX = "mem.pool.type.";
    public static final String PROP_MEM_POOL_COUNT = "mem.pool.count";
    public static final String PROP_MEM_POOL_TELEC_INIT_PREFIX = "telec.mem.pool.init.";
    public static final String PROP_MEM_POOL_TELEC_MAX_PREFIX = "telec.mem.pool.max.";
    public static final String PROP_EVENT_TABLE_DESCRIPTION_PREFIX = "event.table.description.";
    public static final int AGENT_PROTOCOL_VERSION = 20160628;
    public static final int UI_PROTOCOL_VERSION = 20071015;
    public static final long SNAPSHOT_WITH_HEAP = 1L;
    public static final long SNAPSHOT_WITH_CPU_TRACING_RESULTS = 8L;
    public static final long SNAPSHOT_HPROF = 16L;
    public static final long SNAPSHOT_ON_SHUTDOWN = 32L;
    public static final long SNAPSHOT_OIDS_ARE_INDICES = 512L;
    public static final long SNAPSHOT_ON_EVENT = 4096L;
    public static final long SNAPSHOT_EXTRACTED_PERFORMANCE = 8192L;
    public static final long SNAPSHOT_AGENT_ATTACHED = 16384L;
    public static final long SNAPSHOT_AGENT_LOADED_ON_START = 32768L;
    public static final int MARKER_TYPE_BIT_AGENT = 1;
    public static final int MARKER_TYPE_BIT_AGENT_ATTACHED = 8;
    public static final int MARKER_TYPE_BIT_AGENT_LOADED_ON_START = 16;
    public static final int MARKER_TYPE_BIT_SILVERLIGHT = 128;
    public static final int COLUMN_TYPE_INT = 0;
    public static final int COLUMN_TYPE_LONG = 1;
    public static final int COLUMN_TYPE_STRING = 2;
    public static final int COLUMN_TYPE_FOREIGN_KEY = 3;
    public static final int COLUMN_TYPE_CLASS_NAME = 4;
    public static final int COLUMN_TYPE_OBJECT = 5;
    public static final String EVENT_TABLE_PREDEFINED_COLUMN_UPTIME_NS = "uptime_ns";
    public static final String EVENT_TABLE_PREDEFINED_COLUMN_UPTIME_NS_END = "uptime_ns.end";
    public static final String EVENT_TABLE_PREDEFINED_COLUMN_EXCEPTION_STR = "exception_str";
    public static final String EVENT_TABLE_PREDEFINED_COLUMN_THREAD = "thread";
    public static final String EVENT_TABLE_PREDEFINED_COLUMN_STACKTRACE = "frame";
    public static final String EVENT_TABLE_PREDEFINED_COLUMN_RESOURCE_OBJECT_ID = "resource_object_id";
    public static final String EVENT_TABLE_PREDEFINED_COLUMN_RESOURCE_OBJECT_CLASS = "Class";
    public static final int EVENT_TABLE_LIMIT = 128;
    public static final int CORE_TABLE_COUNT = 20;
    public static final int FIRST_EVENT_TABLE = 32;
    public static final long NANOS_PER_SEC = 1000000000L;
    public static final long NANOS_PER_MILLISECOND = 1000000L;
    public static final long NANOS_PER_MICROSECOND = 1000L;
    public static final long MS_PER_DS = 100L;
    public static final int BYTES_IN_MB = 0x100000;
    public static final boolean SAMPLED_ALLOCATION_RECORDING_SUPPORTED = true;
    public static final boolean JAVA_LAUNCHER_SUPPORTS_D32_AND_D64;
    public static final int NO_LINE = 0;
    public static final Charset UTF8;
    public static final int OOME_DUMPER_STATUS_YET_UNKNOWN = -2;
    public static final int OOME_DUMPER_STATUS_UNSUPPORTED = -1;
    public static final int OOME_DUMPER_STATUS_OFF = 0;
    public static final int OOME_DUMPER_STATUS_ON = 1;

    static {
        String path = null;
        try {
            path = System.getenv("YOURKIT_HOME");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (path == null || path.isEmpty()) {
            path = System.getProperty("user.home");
        }
        USER_HOME = new File(path);
        SNAPSHOT_DIR = new File(USER_HOME, "Snapshots");
        APP_SETTINGS_DIR = new File(USER_HOME, ".yjp");
        CONFIG_DIR = new File(APP_SETTINGS_DIR, "config");
        TRACING_SETTINGS_FILE = new File(APP_SETTINGS_DIR, "tracing.txt");
        SAMPLING_SETTINGS_FILE = new File(APP_SETTINGS_DIR, "sampling.txt");
        PREFERRED_SNAPSHOT_DIR_FILE = new File(APP_SETTINGS_DIR, "snapshotdir.txt");
        OS = System.getProperty(PROP_OS_NAME);
        OS_WINDOWS = OS.toLowerCase().startsWith("windows");
        OS_LINUX = OS.toLowerCase().startsWith("linux");
        OS_SOLARIS = OS.toLowerCase().startsWith("sunos");
        OS_MAC = OS.toLowerCase().startsWith("mac os x");
        OS_FREEBSD = OS.toLowerCase().startsWith("freebsd");
        OS_HPUX = OS.toLowerCase().startsWith("hp-ux");
        OS_AIX = OS.toLowerCase().startsWith("aix");
        ARCH = System.getProperty(PROP_OS_ARCH, "");
        ARCH_AMD64 = "amd64".equals(ARCH);
        ARCH_ARM_32 = "arm".equals(ARCH);
        ARCH_ARM_64 = "aarch64".equals(ARCH);
        ARCH_PPC64LE = ARCH.contains("ppc64le");
        ARCH_PPC = ARCH.contains("ppc");
        JAVA_VERSION = System.getProperty(PROP_JAVA_VERSION);
        JAVA_VERSION_6_OR_NEWER = JAVA_VERSION.compareTo("1.6") >= 0;
        JAVA_VERSION_7_OR_NEWER = JAVA_VERSION.compareTo("1.7") >= 0;
        LINE_SEPARATOR = System.getProperty("line.separator", OS_WINDOWS ? "\r\n" : "\n");
        DEMO = "true".equals(System.getProperty("yjp.demo"));
        MESSAGE_DLG_TITLE = APP_FULL_NAME = DEMO ? APP_SHORT_NAME : "YourKit Java Profiler 2016.02-b43";
        ERROR_DLG_TITLE = "Error - " + APP_FULL_NAME;
        WARNING_DLG_TITLE = "Warning - " + APP_FULL_NAME;
        INTERNAL_ERROR_DLG_TITLE = "Internal Error - " + APP_FULL_NAME;
        DEFAULT_PORTS = new int[]{10001, 10002, 10003, 10004, 10005, 10006, 10007, 10008, 10009, 10010};
        JAVA_LAUNCHER_SUPPORTS_D32_AND_D64 = OS_MAC || OS_SOLARIS || OS_HPUX;
        UTF8 = Charset.forName("UTF-8");
    }
}

