/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions;

import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.TemplateLanguageFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;

public class PublishedFileBrowserUrlProvider
extends WebBrowserUrlProvider
implements DumbAware {
    @Nullable
    protected Url getUrl(@NotNull OpenInBrowserRequest request, @NotNull VirtualFile file) {
        Url url;
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/jetbrains/plugins/webDeployment/actions/PublishedFileBrowserUrlProvider", "getUrl"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/actions/PublishedFileBrowserUrlProvider", "getUrl"));
        }
        FileType fileType = file.getFileType();
        if (fileType instanceof TemplateLanguageFileType && !fileType.getName().equals("ASP")) {
            return null;
        }
        Set languages = request.getFile().getViewProvider().getLanguages();
        if ((languages.contains(HTMLLanguage.INSTANCE) || languages.contains(XHTMLLanguage.INSTANCE) || languages.contains(XMLLanguage.INSTANCE)) && (url = PublishedFileBrowserUrlProvider.getUrl(request.getProject(), file)) != null) {
            BuiltInServerManager serverManager = BuiltInServerManager.getInstance();
            return serverManager.isOnBuiltInWebServer(url) ? serverManager.addAuthToken(url) : url;
        }
        return null;
    }

    @Nullable
    public static Url getUrl(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/actions/PublishedFileBrowserUrlProvider", "getUrl"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/actions/PublishedFileBrowserUrlProvider", "getUrl"));
        }
        PublishConfig publishConfig = PublishConfig.getInstance(project);
        WebServerConfig server = publishConfig.findDefaultServer();
        String url = publishConfig.mapToWebPath(file.getPath(), server);
        return url == null ? null : Urls.parseFromIdea((CharSequence)url);
    }
}

