/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions.createproject;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ActionTypeDescription {
    private static final Logger LOG = Logger.getInstance(ActionTypeDescription.class);
    public final String key;
    public final boolean isRecursive;
    public final Icon closedIcon;
    public final String title;
    public final String description;
    public final int keystroke;
    public static final Remote REMOTE_EXCLUDE_FOLDERS_ACTION_DESCRIPTION = new Remote("remoteExcludedRoots", true, AllIcons.Modules.ExcludeRoot, WDBundle.message("excluded.from.index.action.text", new Object[0]), WDBundle.message("excluded.from.index.action.description", new Object[0]), 69){

        @Override
        protected void apply(Collection<WebServerConfig.RemotePath> paths, VirtualFile baseDir, Project project, WebServerConfig server, PublishConfig config) {
            if (paths.isEmpty()) {
                return;
            }
            ModuleManager manager = ModuleManager.getInstance((Project)project);
            Module[] modules = manager.getModules();
            if (modules.length == 0) {
                return;
            }
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)modules[0]).getModifiableModel();
            ContentEntry[] contentEntries = model.getContentEntries();
            if (contentEntries.length == 0) {
                return;
            }
            Collection sourceRoots = ActionTypeDescription.mapToLocalUrls(paths, server, config, true);
            for (String file : sourceRoots) {
                ActionTypeDescription.addUrlToExcluded(file, contentEntries);
            }
            ApplicationManager.getApplication().runWriteAction(() -> model.commit());
        }
    };
    public static final Remote REMOTE_RESOURCE_ROOTS_ACTION_DESCRIPTION = new Remote("remoteResourceRoots", false, AllIcons.Modules.SourceRoot, WDBundle.message("resource.root.action.title", new Object[0]), WDBundle.message("resource.root.action.description", new Object[0]), 82){

        @Override
        protected void apply(Collection<WebServerConfig.RemotePath> paths, VirtualFile baseDir, @Nullable Project project, WebServerConfig server, PublishConfig config) {
            Collection sourceRoots = ActionTypeDescription.mapToLocalUrls(paths, server, config, true);
            ActionTypeDescription.writePathsToFile(sourceRoots, baseDir, "idea_temp_RemoteResourceRootsList");
        }
    };
    static final Local LOCAL_EXCLUDE_FOLDERS_ACTION_DESCRIPTION = new Local("localExcludedRoots", true, AllIcons.Modules.ExcludeRoot, WDBundle.message("excluded.action.title", new Object[0]), WDBundle.message("excluded.from.index.action.description", new Object[0]), 69){

        @Override
        protected void apply(Collection<VirtualFile> paths, VirtualFile baseDir, Project project) {
            if (paths.isEmpty()) {
                return;
            }
            ModuleManager manager = ModuleManager.getInstance((Project)project);
            Module[] modules = manager.getModules();
            if (modules.length == 0) {
                return;
            }
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)modules[0]).getModifiableModel();
            ContentEntry[] contentEntries = model.getContentEntries();
            if (contentEntries.length == 0) {
                return;
            }
            for (VirtualFile file : paths) {
                ActionTypeDescription.addUrlToExcluded(file.getUrl(), contentEntries);
            }
            ApplicationManager.getApplication().runWriteAction(() -> model.commit());
        }
    };
    private static final Function<VirtualFile, String> PATH_FUNCTION = file -> file.getUrl();
    static final Local LOCAL_RESOURCE_ROOTS_ACTION_DESCRIPTION = new Local("localResourceRoots", false, AllIcons.Modules.SourceRoot, WDBundle.message("resource.root.action.title", new Object[0]), WDBundle.message("resource.root.action.description", new Object[0]), 82){

        @Override
        protected void apply(Collection<VirtualFile> paths, VirtualFile baseDir, @Nullable Project project) {
            ActionTypeDescription.writePathsToFile(ContainerUtil.map2List(paths, (Function)PATH_FUNCTION), baseDir, "idea_temp_LocalResourceRootsList");
        }
    };
    static final Local LOCAL_TEST_ROOTS_ACTION_DESCRIPTION = new Local("localTestSources", false, AllIcons.Modules.TestRoot, WDBundle.message("test.sources.action.title", new Object[0]), WDBundle.message("test.sources.action.description", new Object[0]), 84){

        @Override
        protected void apply(Collection<VirtualFile> paths, VirtualFile baseDir, @Nullable Project project) {
            if (paths.isEmpty() || project == null) {
                return;
            }
            ModuleManager manager = ModuleManager.getInstance((Project)project);
            Module[] modules = manager.getModules();
            if (modules.length == 0) {
                return;
            }
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)modules[0]).getModifiableModel();
            ContentEntry[] contentEntries = model.getContentEntries();
            if (contentEntries.length == 0) {
                return;
            }
            for (VirtualFile file : paths) {
                contentEntries[0].addSourceFolder(file, true);
            }
            ApplicationManager.getApplication().runWriteAction(() -> model.commit());
        }
    };

    public ActionTypeDescription(@NonNls @NotNull String key, boolean recursive, @NotNull Icon closedIcon, @NotNull String title, @NotNull String description, int keystroke) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/plugins/webDeployment/actions/createproject/ActionTypeDescription", "<init>"));
        }
        if (closedIcon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closedIcon", "com/jetbrains/plugins/webDeployment/actions/createproject/ActionTypeDescription", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/plugins/webDeployment/actions/createproject/ActionTypeDescription", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/jetbrains/plugins/webDeployment/actions/createproject/ActionTypeDescription", "<init>"));
        }
        this.key = key;
        this.isRecursive = recursive;
        this.closedIcon = closedIcon;
        this.title = title;
        this.description = description;
        this.keystroke = keystroke;
    }

    private static void writePathsToFile(final Collection<String> paths, final VirtualFile baseDir, final @NonNls String fileName) {
        if (!paths.isEmpty()) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    OutputStreamWriter writer = null;
                    try {
                        VirtualFile file = baseDir.createChildData((Object)this, fileName);
                        writer = new OutputStreamWriter(file.getOutputStream((Object)this), file.getCharset());
                        boolean next = false;
                        for (String sourceRoot : paths) {
                            if (next) {
                                writer.write("\n");
                            }
                            writer.write(sourceRoot);
                            next = true;
                        }
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                    finally {
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            });
        }
    }

    private static Collection<String> mapToLocalUrls(Collection<WebServerConfig.RemotePath> paths, WebServerConfig server, PublishConfig config, boolean createMissingItemsAsFolders) {
        ArrayList<String> urls = new ArrayList<String>();
        boolean isMounted = !server.getFileTransferConfig().getAccessType().isProtocolBased();
        String mountedFolder = server.getFileTransferConfig().getMountedFolder();
        for (WebServerConfig.RemotePath path : paths) {
            if (isMounted) {
                path = new WebServerConfig.RemotePath(DeploymentPathUtils.join(mountedFolder, path.path, File.separatorChar));
            }
            DeploymentPathMapping result = null;
            for (DeploymentPathMapping mapping : config.getPathMappings(server.getId())) {
                if (!mapping.isLocalPathValid() || !mapping.isParentForDeployPath(path, false, (Mappable)server) || result != null && !result.isParentByDeployPath(mapping, server.isCaseSensitive())) continue;
                result = mapping;
            }
            if (result == null) {
                LOG.error("Failed to find mapping for path ''" + path.path + "''");
                continue;
            }
            String localPath = result.mapToLocalPath(path, (Mappable)server);
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(localPath);
            if (file == null) {
                LOG.warn("Failed to find file for relative project path ''" + localPath + "''");
                if (!createMissingItemsAsFolders) continue;
                Ref fileRef = new Ref();
                ApplicationManager.getApplication().runWriteAction(() -> {
                    try {
                        fileRef.set((Object)VfsUtil.createDirectoryIfMissing((String)localPath));
                    }
                    catch (IOException e) {
                        LOG.error("Failed to create directory ''" + localPath + "''.");
                    }
                });
                if (fileRef.isNull()) continue;
                file = (VirtualFile)fileRef.get();
            }
            urls.add(file.getUrl());
        }
        return urls;
    }

    private static void addUrlToExcluded(String url, ContentEntry[] contentEntries) {
        String path = VfsUtilCore.urlToPath((String)url);
        for (ContentEntry entry : contentEntries) {
            String rootPath = VfsUtilCore.urlToPath((String)entry.getUrl());
            if (!FileUtil.isAncestor((String)rootPath, (String)path, (boolean)false)) continue;
            entry.addExcludeFolder(url);
        }
    }

    public static abstract class Remote
    extends ActionTypeDescription {
        public Remote(@NonNls @NotNull String key, boolean recursive, @NotNull Icon closedIcon, @NotNull String title, @NotNull String description, int keystroke) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/plugins/webDeployment/actions/createproject/ActionTypeDescription$Remote", "<init>"));
            }
            if (closedIcon == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closedIcon", "com/jetbrains/plugins/webDeployment/actions/createproject/ActionTypeDescription$Remote", "<init>"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/plugins/webDeployment/actions/createproject/ActionTypeDescription$Remote", "<init>"));
            }
            if (description == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/jetbrains/plugins/webDeployment/actions/createproject/ActionTypeDescription$Remote", "<init>"));
            }
            super(key, recursive, closedIcon, title, description, keystroke);
        }

        protected void apply(MultiMap<String, WebServerConfig.RemotePath> localActionPaths, VirtualFile baseDir, @Nullable Project project, WebServerConfig server, PublishConfig config) {
            this.apply(localActionPaths.get((Object)this.key), baseDir, project, server, config);
        }

        protected abstract void apply(Collection<WebServerConfig.RemotePath> var1, VirtualFile var2, @Nullable Project var3, WebServerConfig var4, PublishConfig var5);
    }

    public static abstract class Local
    extends ActionTypeDescription {
        public Local(@NonNls @NotNull String key, boolean recursive, @NotNull Icon closedIcon, @NotNull String title, @NotNull String description, int keystroke) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/plugins/webDeployment/actions/createproject/ActionTypeDescription$Local", "<init>"));
            }
            if (closedIcon == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closedIcon", "com/jetbrains/plugins/webDeployment/actions/createproject/ActionTypeDescription$Local", "<init>"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/plugins/webDeployment/actions/createproject/ActionTypeDescription$Local", "<init>"));
            }
            if (description == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/jetbrains/plugins/webDeployment/actions/createproject/ActionTypeDescription$Local", "<init>"));
            }
            super(key, recursive, closedIcon, title, description, keystroke);
        }

        protected void apply(MultiMap<String, VirtualFile> localActionPaths, VirtualFile baseDir, @Nullable Project project) {
            this.apply(localActionPaths.get((Object)this.key), baseDir, project);
        }

        protected abstract void apply(Collection<VirtualFile> var1, VirtualFile var2, @Nullable Project var3);
    }
}

