/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.credentialStore.Credentials;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.util.EventDispatcher;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.jcraft.jsch.UserInfo;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.ServerPasswordSafeDeployable;
import com.jetbrains.plugins.webDeployment.config.SftpUserInfo;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionManager;
import com.jetbrains.plugins.webDeployment.transport.SshConnectionService;
import java.io.File;
import java.text.MessageFormat;
import java.util.concurrent.TimeoutException;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.auth.StaticUserAuthenticator;
import org.apache.commons.vfs2.impl.DefaultFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.sftp.IdentityRepositoryFactory;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ServerBaseDeployable
implements Deployable {
    private static final Logger LOG = Logger.getInstance(ServerBaseDeployable.class);
    @NotNull
    protected WebServerConfig myServer;

    public ServerBaseDeployable(@NotNull WebServerConfig server) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/jetbrains/plugins/webDeployment/config/ServerBaseDeployable", "<init>"));
        }
        this.myServer = server;
    }

    @NotNull
    public WebServerConfig getServer() {
        WebServerConfig webServerConfig = this.myServer;
        if (webServerConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/ServerBaseDeployable", "getServer"));
        }
        return webServerConfig;
    }

    @Override
    @Nls
    public String getRootNodePresentableDescription(boolean showRootFolder) {
        if (this.myServer.getAccessType().isProtocolBased()) {
            if (showRootFolder) {
                return MessageFormat.format("{0} ({1}{2})", this.myServer.getName(), this.getHost(), this.myServer.getFileTransferConfig().getRootFolder());
            }
            return MessageFormat.format("{0} ({1})", this.myServer.getName(), this.getHost());
        }
        return MessageFormat.format("{0} ({1})", this.myServer.getName(), this.myServer.getFileTransferConfig().getMountedFolder());
    }

    @Override
    @Nls
    public String getName() {
        return this.myServer.getName();
    }

    @Override
    @NotNull
    public FileSystemOptions getConnectionOptions(@NotNull ConnectionOwner connectionOwner, @NotNull String title, FileTransferConfig.Origin originOption, @Nullable EventDispatcher<RemoteConnectionManager.ForceDisconnectListener> disconnectTrigger, @Nullable ProgressIndicator pi) {
        FileSystemOptions options;
        block14: {
            if (connectionOwner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/webDeployment/config/ServerBaseDeployable", "getConnectionOptions"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/plugins/webDeployment/config/ServerBaseDeployable", "getConnectionOptions"));
            }
            options = this.myServer.getConnectionOptions(connectionOwner, title, originOption, disconnectTrigger, pi);
            FileTransferConfig ftc = this.myServer.getFileTransferConfig();
            if (!ftc.getAccessType().isProtocolBased()) {
                FileSystemOptions fileSystemOptions = options;
                if (fileSystemOptions == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/ServerBaseDeployable", "getConnectionOptions"));
                }
                return fileSystemOptions;
            }
            try {
                if (ftc.getAccessType() == AccessType.FTP) {
                    Credentials credentials = ftc.isAnonymous() ? new Credentials("anonymous", "user@example.com") : this.getCredentials();
                    String userName = credentials == null ? null : credentials.getUserName();
                    String password = credentials == null ? null : credentials.getPasswordAsString();
                    StaticUserAuthenticator auth = new StaticUserAuthenticator(null, userName, password);
                    DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(options, (UserAuthenticator)auth);
                    break block14;
                }
                if (ftc.getAccessType() == AccessType.SFTP) {
                    Credentials credentials;
                    Credentials credentials2 = credentials = this.isAnonymous() ? new Credentials("anonymous", "user@example.com") : this.getCredentials();
                    if (ftc.getAuthType() == AuthType.KEY_PAIR) {
                        DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(options, (UserAuthenticator)new StaticUserAuthenticator(null, credentials == null ? null : credentials.getUserName(), null));
                        SftpFileSystemConfigBuilder.getInstance().setIdentities(options, new File[]{new File(ftc.getPrivateKeyFile())});
                    } else if (ftc.getAuthType() == AuthType.AUTH_AGENT) {
                        DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(options, (UserAuthenticator)new StaticUserAuthenticator(null, credentials == null ? null : credentials.getUserName(), null));
                        SftpFileSystemConfigBuilder.getInstance().setIdentities(options, new File[0]);
                        SftpFileSystemConfigBuilder.getInstance().setIdentityRepositoryFactory(options, (IdentityRepositoryFactory)SshConnectionService.Companion.getInstance().getAuthAgentIdentityRepositoryFactory());
                    } else {
                        DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(options, (UserAuthenticator)new StaticUserAuthenticator(null, credentials == null ? null : credentials.getUserName(), credentials == null ? null : credentials.getPasswordAsString()));
                        SftpFileSystemConfigBuilder.getInstance().setIdentities(options, new File[0]);
                    }
                    SftpFileSystemConfigBuilder.getInstance().setUserInfo(options, (UserInfo)new SftpUserInfo(ftc, connectionOwner, title, this, pi));
                    break block14;
                }
                if (ftc.getAccessType() == AccessType.FTPS) {
                    Credentials credentials = ftc.isAnonymous() ? new Credentials("anonymous", "user@example.com") : this.getCredentials();
                    String userName = credentials == null ? null : credentials.getUserName();
                    String password = credentials == null ? null : credentials.getPasswordAsString();
                    StaticUserAuthenticator auth = new StaticUserAuthenticator(null, userName, password);
                    DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(options, (UserAuthenticator)auth);
                    break block14;
                }
                throw new IllegalStateException("Unknown access type " + (Object)((Object)ftc.getAccessType()));
            }
            catch (FileSystemException e) {
                LOG.error((Throwable)e);
            }
        }
        WebServerConfig.checkProperEqualsAndHash(options);
        FileSystemOptions fileSystemOptions = options;
        if (fileSystemOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/ServerBaseDeployable", "getConnectionOptions"));
        }
        return fileSystemOptions;
    }

    @Override
    public boolean hasCredentials() {
        FileTransferConfig fileTransferConfig = this.myServer.getFileTransferConfig();
        if (fileTransferConfig.isAnonymous() || !fileTransferConfig.getAccessType().isProtocolBased() || fileTransferConfig.getAuthType() == AuthType.AUTH_AGENT) {
            return true;
        }
        Credentials credentials = this.getCredentials();
        if (credentials != null && credentials.getUserName() != null && credentials.getPasswordAsString() != null) {
            return true;
        }
        if (fileTransferConfig.getAuthType() == AuthType.KEY_PAIR) {
            try {
                if (!KeyPair.load((JSch)new JSch(), (String)fileTransferConfig.getPrivateKeyFile()).isEncrypted()) {
                    return true;
                }
            }
            catch (JSchException e) {
                LOG.warn((Throwable)e);
                return false;
            }
        }
        return false;
    }

    @Override
    public void clearPasswordIfNotStored() {
        if (!this.getAccessType().isProtocolBased() || this.isAnonymous()) {
            return;
        }
        Credentials credentials = this.getCredentials();
        if (credentials != null && credentials.getPassword() != null && credentials.getPassword().length() > 0 && this.isPassMemoryOnly()) {
            String userName = credentials.getUserName();
            Credentials credentialsToSet = StringUtil.isEmptyOrSpaces((String)userName) ? null : new Credentials(userName, (String)null);
            this.setCredentials(credentialsToSet, true, this instanceof ServerPasswordSafeDeployable, false);
        }
    }

    @Override
    @NotNull
    public AccessType getAccessType() {
        AccessType accessType = this.myServer.getAccessType();
        if (accessType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/ServerBaseDeployable", "getAccessType"));
        }
        return accessType;
    }

    @Override
    public boolean isProjectLevel() {
        return this.myServer.isProjectLevel();
    }

    @Override
    public String getHost() {
        return this.myServer.getFileTransferConfig().getHost();
    }

    @Override
    public String getLiteralPort() {
        return this.myServer.getFileTransferConfig().getLiteralPort();
    }

    @Override
    public boolean isUseKeyPair() {
        return this.myServer.getFileTransferConfig().isUseKeyPair();
    }

    @Override
    public boolean isUseAuthAgent() {
        return this.myServer.getFileTransferConfig().isUseAuthAgent();
    }

    @Override
    @NotNull
    public AuthType getAuthType() {
        AuthType authType = this.myServer.getFileTransferConfig().getAuthType();
        if (authType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/ServerBaseDeployable", "getAuthType"));
        }
        return authType;
    }

    @Override
    public String getPrivateKeyFile() {
        return this.myServer.getFileTransferConfig().getPrivateKeyFile();
    }

    @Override
    public boolean isDefaultRootFolder() {
        FileTransferConfig c = this.myServer.getFileTransferConfig();
        return c.getAccessType().getDefaultRootFolder().equals(c.getRootFolder());
    }

    @Override
    public boolean isCaseSensitive() {
        return this.myServer.isCaseSensitive();
    }

    @Override
    public String getRootUri() {
        return this.myServer.getRootUri();
    }

    @Override
    public int getMaxConnections() {
        return this.myServer.getMaxConnections();
    }

    @Override
    public AdvancedOptionsConfig.AccurateTimestamps getAccurateTimestamps() {
        return this.myServer.getAccurateTimestamps();
    }

    @Override
    @NotNull
    public ServerBaseDeployable clone() {
        ServerBaseDeployable serverBaseDeployable;
        try {
            ServerBaseDeployable clone = (ServerBaseDeployable)super.clone();
            clone.myServer = this.myServer.clone();
            serverBaseDeployable = clone;
        }
        catch (CloneNotSupportedException e) {
            if (null == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/ServerBaseDeployable", "clone"));
            }
            return null;
        }
        if (serverBaseDeployable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/ServerBaseDeployable", "clone"));
        }
        return serverBaseDeployable;
    }

    @Override
    public boolean isBasedOnServer(WebServerConfig server) {
        return !StringUtil.isEmptyOrSpaces((String)this.myServer.getId()) && this.myServer.getId().equals(server.getId());
    }

    @Override
    public String validateSlow(long timeout) throws TimeoutException {
        return this.myServer.validateSlow(timeout);
    }

    @Override
    public String validateInternalSlow(long timeout, boolean checkRootFolder) throws TimeoutException {
        return this.myServer.getFileTransferConfig().validateSlow(timeout, checkRootFolder);
    }

    @Override
    public String validateFastInternal() {
        return this.myServer.getFileTransferConfig().validateFast();
    }

    @Override
    public String validateFastInternal(boolean checkRootFolder) {
        return this.myServer.getFileTransferConfig().validateFast(checkRootFolder);
    }

    @Override
    public String validateFast() {
        return this.myServer.validateFast();
    }

    @Override
    @Nullable
    public String getId() {
        return this.myServer.getId();
    }

    @Override
    public String getPresentablePath(FileName name) {
        return this.myServer.getPresentablePath(name);
    }

    @Override
    public String getPresentablePath(WebServerConfig.RemotePath path) {
        return this.myServer.getPresentablePath(path);
    }

    @Override
    public String getFullPath(String deployPath) {
        return this.myServer.getFullPath(deployPath);
    }

    @Override
    @Nullable
    public String validateUrl() {
        return this.myServer.validateUrl();
    }

    @Override
    public String getUrl() {
        return this.myServer.getUrl();
    }

    @Override
    public WebServerConfig.RemotePath getRootPath() {
        return this.myServer.getRootPath();
    }

    @Override
    public boolean isAnonymous() {
        return this.myServer.getFileTransferConfig().isAnonymous();
    }

    @Override
    public String getKnownHostsFile() {
        return this.myServer.getFileTransferConfig().getKnownHostsFile();
    }

    @Override
    @Nullable
    public String getMountedFolder() {
        return this.myServer.getFileTransferConfig().getMountedFolder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerBaseDeployable that = (ServerBaseDeployable)o;
        return this.myServer.equals(that.myServer);
    }

    public int hashCode() {
        return this.myServer.hashCode();
    }

    public String toString() {
        return "ServerBaseDeployable{myServer=" + this.myServer + '}';
    }
}

