/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.stylus.psi;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.stylus.StylusFileType;
import org.jetbrains.plugins.stylus.psi.StylusFile;
import org.jetbrains.plugins.stylus.psi.impl.StylusMixinImpl;
import org.jetbrains.plugins.stylus.psi.impl.StylusVariableImpl;

public class StylusElementGenerator {
    @Nullable
    public static StylusVariableImpl createVariable(Project project, String text) {
        CssStylesheet stylesheet = StylusElementGenerator.createFileFromText(project, text + " = testVar").getStylesheet();
        return (StylusVariableImpl)PsiTreeUtil.findChildOfType((PsiElement)stylesheet, StylusVariableImpl.class);
    }

    @Nullable
    public static StylusMixinImpl createMixin(Project project, String text) {
        CssStylesheet stylesheet = StylusElementGenerator.createFileFromText(project, text + "()\n  color: black").getStylesheet();
        return (StylusMixinImpl)PsiTreeUtil.findChildOfType((PsiElement)stylesheet, StylusMixinImpl.class);
    }

    @NotNull
    private static StylusFile createFileFromText(Project project, @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/stylus/psi/StylusElementGenerator", "createFileFromText"));
        }
        StylusFile stylusFile = (StylusFile)PsiFileFactory.getInstance((Project)project).createFileFromText("foo.stylus", (FileType)StylusFileType.STYLUS, (CharSequence)text);
        if (stylusFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/psi/StylusElementGenerator", "createFileFromText"));
        }
        return stylusFile;
    }
}

