/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor.runner;

import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.javascript.debugger.LocalFileSystemFileFinder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MeteorFileFinder
extends LocalFileSystemFileFinder {
    @Nullable
    final VirtualFile virtualDir;
    final VirtualFile meteorDir;
    final File isopacksDir;

    public MeteorFileFinder(@NotNull String workDir) {
        if (workDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workDir", "com/jetbrains/plugins/meteor/runner/MeteorFileFinder", "<init>"));
        }
        this.isopacksDir = new File(workDir, ".meteor" + File.separatorChar + "local" + File.separatorChar + "isopacks");
        this.virtualDir = LocalFileSystem.getInstance().findFileByPath(workDir);
        this.meteorDir = this.virtualDir == null ? null : this.virtualDir.findChild(".meteor");
        JavaScriptDebugProcessKt.getLOG().assertTrue(this.virtualDir != null);
        JavaScriptDebugProcessKt.getLOG().assertTrue(this.meteorDir != null);
    }

    @Nullable
    public VirtualFile findFile(@NotNull Url url, @NotNull Project project) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/plugins/meteor/runner/MeteorFileFinder", "findFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/meteor/runner/MeteorFileFinder", "findFile"));
        }
        VirtualFile file = super.findFile(url, project);
        return file == null && this.virtualDir != null ? this.findFileInWorkingDirectory(url.getPath()) : file;
    }

    VirtualFile findFileInWorkingDirectory(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/plugins/meteor/runner/MeteorFileFinder", "findFileInWorkingDirectory"));
        }
        int i = path.indexOf(47);
        while (i != -1) {
            String subPath = path.substring(i + 1, path.length());
            assert (this.virtualDir != null);
            VirtualFile file = this.virtualDir.findFileByRelativePath(subPath);
            if (file != null) {
                return file;
            }
            i = path.indexOf(47, i + 2);
        }
        return null;
    }

    public boolean isOnlySourceMappedBreakpoints(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/meteor/runner/MeteorFileFinder", "isOnlySourceMappedBreakpoints"));
        }
        boolean result = super.isOnlySourceMappedBreakpoints(file);
        if (!result && this.meteorDir != null) {
            return !VfsUtilCore.isAncestor((VirtualFile)this.meteorDir, (VirtualFile)file, (boolean)true);
        }
        return result;
    }
}

