/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.reactnative;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.chrome.ChromeSettings;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import com.jetbrains.plugins.reactnative.ReactNativeProcessStateKt;
import com.jetbrains.plugins.reactnative.ReactNativeProgramRunnerKt;
import com.jetbrains.plugins.reactnative.ReactNativeRunConfiguration;
import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J\u001f\u0010\u000b\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/plugins/reactnative/ReactNativeProcessState;", "Lcom/intellij/execution/configurations/RunProfileState;", "configuration", "Lcom/jetbrains/plugins/reactnative/ReactNativeRunConfiguration;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "(Lcom/jetbrains/plugins/reactnative/ReactNativeRunConfiguration;Lcom/intellij/execution/runners/ExecutionEnvironment;)V", "getConfiguration", "()Lcom/jetbrains/plugins/reactnative/ReactNativeRunConfiguration;", "getEnvironment", "()Lcom/intellij/execution/runners/ExecutionEnvironment;", "execute", "Lcom/intellij/execution/ExecutionResult;", "executor", "Lcom/intellij/execution/Executor;", "runner", "Lcom/intellij/execution/runners/ProgramRunner;", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "debugPort", "", "execute$ChromeConnector", "findProxyResource", "", "startChromeProcess", "Lcom/intellij/execution/process/ProcessHandler;", "startNodeProcess", "Lcom/intellij/execution/process/OSProcessHandler;", "ChromeConnector"})
public final class ReactNativeProcessState
implements RunProfileState {
    @NotNull
    private final ReactNativeRunConfiguration configuration;
    @NotNull
    private final ExecutionEnvironment environment;

    @Nullable
    public ExecutionResult execute(@Nullable Executor executor, @NotNull ProgramRunner<?> runner) {
        Intrinsics.checkParameterIsNotNull(runner, (String)"runner");
        throw (Throwable)new NotImplementedError("Should be started in ReactNativeProgramRunner");
    }

    @NotNull
    public final ExecutionResult execute$ChromeConnector(@Nullable WebBrowser browser, int debugPort) {
        ProcessHandler processHandler = browser != null ? this.startChromeProcess(browser, debugPort) : (ProcessHandler)this.startNodeProcess(debugPort);
        TextConsoleBuilder consoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(this.environment.getProject());
        ConsoleView console = consoleBuilder.getConsole();
        console.attachToProcess(processHandler);
        return (ExecutionResult)new DefaultExecutionResult((ExecutionConsole)console, processHandler);
    }

    private final ProcessHandler startChromeProcess(WebBrowser browser, int debugPort) {
        GeneralCommandLine commandLine = new GeneralCommandLine();
        String string = browser.getPath();
        if (string == null) {
            throw (Throwable)((Object)new AssertionError((Object)"Browser path is null. Must be checked in React Native run configuration."));
        }
        commandLine.setExePath(string);
        commandLine.addParameter("--remote-debugging-port=" + debugPort);
        BrowserSpecificSettings browserSpecificSettings = browser.getSpecificSettings();
        if (!(browserSpecificSettings instanceof ChromeSettings)) {
            browserSpecificSettings = null;
        }
        ChromeSettings chromeSettings = (ChromeSettings)browserSpecificSettings;
        if (chromeSettings == null) {
            throw (Throwable)((Object)new AssertionError((Object)"Browser is not Chrome. Must be checked in React Native run configuration."));
        }
        ChromeSettings chromeSettings2 = chromeSettings;
        commandLine.addParameters(chromeSettings2.getAdditionalParameters());
        if (!chromeSettings2.isUseCustomProfile()) {
            File userDir = FileUtil.createTempDirectory((String)"reactNativeChromeUserDir", (String)null);
            commandLine.addParameter("--user-data-dir=" + userDir.getAbsolutePath());
            commandLine.addParameter("--no-first-run");
        }
        commandLine.addParameter("--no-default-browser-check");
        commandLine.addParameter(ReactNativeProgramRunnerKt.getCHROME_DEBUG_URL());
        commandLine.withWorkDirectory(this.configuration.getEffectiveWorkingDirectory());
        OSProcessHandler processHandler = new OSProcessHandler(commandLine);
        ProcessTerminatedListener.attach((ProcessHandler)((ProcessHandler)processHandler), (Project)this.environment.getProject());
        return (ProcessHandler)processHandler;
    }

    private final OSProcessHandler startNodeProcess(int debugPort) {
        GeneralCommandLine commandLine = new GeneralCommandLine();
        NodeJsLocalInterpreter interpreter = this.configuration.getNodePath().resolveAsLocal(this.environment.getProject());
        commandLine.setExePath(interpreter.getInterpreterSystemDependentPath());
        NodeCommandLineUtil.addNodeOptionsForDebugging((GeneralCommandLine)commandLine, Collections.emptyList(), (int)debugPort, (boolean)true, (NodeJsInterpreter)((NodeJsInterpreter)interpreter), (boolean)false);
        commandLine.withWorkDirectory(this.configuration.getEffectiveWorkingDirectory());
        String resource = this.findProxyResource();
        String path = resource + File.separator + "launcher.js";
        commandLine.addParameter(path);
        commandLine.addParameter("--port=8081");
        Project project = this.environment.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"environment.project");
        String storagePath = ReactNativeProcessStateKt.reactNativeBuildPath(project);
        FileUtil.createDirectory((File)new File(storagePath));
        commandLine.addParameter("--sourcesStoragePath=" + storagePath);
        if (ReactNativeProcessStateKt.access$getLOG$p().isTraceEnabled()) {
            Map map = commandLine.getEnvironment();
            String string = "RN_LOG_LEVEL";
            String string2 = "Trace";
            map.put(string, string2);
        }
        OSProcessHandler processHandler = new OSProcessHandler(commandLine);
        ProcessTerminatedListener.attach((ProcessHandler)((ProcessHandler)processHandler), (Project)this.environment.getProject());
        return processHandler;
    }

    private final String findProxyResource() {
        String jarPath = PathUtil.getJarPathForClass(ReactNativeProcessState.class);
        if (!StringsKt.endsWith$default((String)jarPath, (String)".jar", (boolean)false, (int)2, null)) {
            URL uRL = ReactNativeProcessState.class.getClassLoader().getResource("proxy");
            if (uRL == null) {
                throw (Throwable)new RuntimeException("Installation corrupted: no react native debugger proxy files found");
            }
            URL resource = uRL;
            String string = resource.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resource.path");
            return string;
        }
        File jarFile = new File(jarPath);
        if (!jarFile.isFile()) {
            throw (Throwable)new RuntimeException("jar file not found");
        }
        File pluginBaseDir = jarFile.getParentFile().getParentFile();
        return pluginBaseDir.getAbsolutePath() + File.separator + "proxy";
    }

    @NotNull
    public final ReactNativeRunConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final ExecutionEnvironment getEnvironment() {
        return this.environment;
    }

    public ReactNativeProcessState(@NotNull ReactNativeRunConfiguration configuration, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        this.configuration = configuration;
        this.environment = environment;
    }
}

