/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.reactnative;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.nodeJs.NodeJSDebuggableConfiguration;
import com.jetbrains.plugins.reactnative.ReactNativeConfigurationEditor;
import com.jetbrains.plugins.reactnative.ReactNativePlatform;
import com.jetbrains.plugins.reactnative.ReactNativeProcessState;
import com.jetbrains.plugins.reactnative.ReactNativeRunConfigurationKt;
import java.net.InetSocketAddress;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u00108\u001a\u000209H\u0016J*\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\b\u0010@\u001a\u0004\u0018\u00010A2\u0006\u0010B\u001a\u00020CH\u0016J\u0006\u0010D\u001a\u00020\rJ\b\u0010E\u001a\u00020FH\u0016J\u0018\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020J2\u0006\u0010B\u001a\u00020CH\u0016J\u0012\u0010K\u001a\u0002092\b\u0010L\u001a\u0004\u0018\u00010MH\u0016J\u0012\u0010N\u001a\u0002092\b\u0010L\u001a\u0004\u0018\u00010MH\u0016R\u0013\u0010\b\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001c\u0010,\u001a\u0004\u0018\u00010-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001a\u00102\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u000f\"\u0004\b4\u0010\u0011R\u001a\u00105\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u000f\"\u0004\b7\u0010\u0011\u00a8\u0006O"}, d2={"Lcom/jetbrains/plugins/reactnative/ReactNativeRunConfiguration;", "Lcom/intellij/execution/configurations/LocatableConfigurationBase;", "Lcom/jetbrains/nodeJs/NodeJSDebuggableConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;)V", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "getBrowser", "()Lcom/intellij/ide/browsers/WebBrowser;", "browserId", "", "getBrowserId", "()Ljava/lang/String;", "setBrowserId", "(Ljava/lang/String;)V", "effectiveWorkingDirectory", "getEffectiveWorkingDirectory", "envData", "Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "getEnvData", "()Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "setEnvData", "(Lcom/intellij/execution/configuration/EnvironmentVariablesData;)V", "nodePath", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef;", "getNodePath", "()Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef;", "setNodePath", "(Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef;)V", "onlyStartPackager", "", "getOnlyStartPackager", "()Z", "setOnlyStartPackager", "(Z)V", "platform", "Lcom/jetbrains/plugins/reactnative/ReactNativePlatform;", "getPlatform", "()Lcom/jetbrains/plugins/reactnative/ReactNativePlatform;", "setPlatform", "(Lcom/jetbrains/plugins/reactnative/ReactNativePlatform;)V", "reactNativePackage", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "getReactNativePackage", "()Lcom/intellij/javascript/nodejs/util/NodePackage;", "setReactNativePackage", "(Lcom/intellij/javascript/nodejs/util/NodePackage;)V", "runArguments", "getRunArguments", "setRunArguments", "workingDirectory", "getWorkingDirectory", "setWorkingDirectory", "checkConfiguration", "", "createDebugProcess", "Lcom/intellij/xdebugger/XDebugProcess;", "socketAddress", "Ljava/net/InetSocketAddress;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "executionResult", "Lcom/intellij/execution/ExecutionResult;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "findWorkingDirectory", "getConfigurationEditor", "Lcom/jetbrains/plugins/reactnative/ReactNativeConfigurationEditor;", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "readExternal", "element", "Lorg/jdom/Element;", "writeExternal", "ChromeConnector"})
public final class ReactNativeRunConfiguration
extends LocatableConfigurationBase
implements NodeJSDebuggableConfiguration {
    @Nullable
    private NodePackage reactNativePackage;
    @NotNull
    private NodeJsInterpreterRef nodePath;
    @NotNull
    private String workingDirectory;
    private boolean onlyStartPackager;
    @NotNull
    private ReactNativePlatform platform;
    @NotNull
    private String runArguments;
    @NotNull
    private EnvironmentVariablesData envData;
    @Nullable
    private String browserId;

    @Nullable
    public final NodePackage getReactNativePackage() {
        return this.reactNativePackage;
    }

    public final void setReactNativePackage(@Nullable NodePackage nodePackage) {
        this.reactNativePackage = nodePackage;
    }

    @NotNull
    public final NodeJsInterpreterRef getNodePath() {
        return this.nodePath;
    }

    public final void setNodePath(@NotNull NodeJsInterpreterRef nodeJsInterpreterRef) {
        Intrinsics.checkParameterIsNotNull((Object)nodeJsInterpreterRef, (String)"<set-?>");
        this.nodePath = nodeJsInterpreterRef;
    }

    @NotNull
    public final String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public final void setWorkingDirectory(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.workingDirectory = string;
    }

    public final boolean getOnlyStartPackager() {
        return this.onlyStartPackager;
    }

    public final void setOnlyStartPackager(boolean bl) {
        this.onlyStartPackager = bl;
    }

    @NotNull
    public final ReactNativePlatform getPlatform() {
        return this.platform;
    }

    public final void setPlatform(@NotNull ReactNativePlatform reactNativePlatform) {
        Intrinsics.checkParameterIsNotNull((Object)reactNativePlatform, (String)"<set-?>");
        this.platform = reactNativePlatform;
    }

    @NotNull
    public final String getRunArguments() {
        return this.runArguments;
    }

    public final void setRunArguments(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.runArguments = string;
    }

    @NotNull
    public final EnvironmentVariablesData getEnvData() {
        return this.envData;
    }

    public final void setEnvData(@NotNull EnvironmentVariablesData environmentVariablesData) {
        Intrinsics.checkParameterIsNotNull((Object)environmentVariablesData, (String)"<set-?>");
        this.envData = environmentVariablesData;
    }

    @Nullable
    public final String getBrowserId() {
        return this.browserId;
    }

    public final void setBrowserId(@Nullable String string) {
        this.browserId = string;
    }

    @NotNull
    public final String getEffectiveWorkingDirectory() {
        String string;
        CharSequence charSequence = this.workingDirectory;
        if (charSequence.length() == 0) {
            String string2 = this.findWorkingDirectory();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"findWorkingDirectory()");
        } else {
            string = this.workingDirectory;
        }
        return string;
    }

    @NotNull
    public final String findWorkingDirectory() {
        return StringUtil.notNullize((String)this.getProject().getBasePath());
    }

    @NotNull
    public XDebugProcess createDebugProcess(@NotNull InetSocketAddress socketAddress, @NotNull XDebugSession session2, @Nullable ExecutionResult executionResult, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkParameterIsNotNull((Object)socketAddress, (String)"socketAddress");
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        throw (Throwable)new RuntimeException("should not be called");
    }

    @NotNull
    public ReactNativeConfigurationEditor getConfigurationEditor() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        return new ReactNativeConfigurationEditor(project);
    }

    @NotNull
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        return new ReactNativeProcessState(this, environment);
    }

    public void checkConfiguration() {
        CharSequence charSequence;
        super.checkConfiguration();
        NodeJsInterpreter interpreter = this.nodePath.resolve(this.getProject());
        NodeJsLocalInterpreter.checkForRunConfiguration((NodeJsInterpreter)interpreter);
        NodePackage reactNative = this.reactNativePackage;
        if (reactNative == null || (charSequence = (CharSequence)reactNative.getSystemDependentPath()).length() == 0) {
            throw (Throwable)new RuntimeConfigurationException("react-native is not specified");
        }
        if (!reactNative.isValid()) {
            throw (Throwable)new RuntimeConfigurationException("invalid react-native");
        }
        WebBrowser webBrowser = this.getBrowser();
        if (webBrowser != null && webBrowser.getPath() == null) {
            throw (Throwable)new RuntimeConfigurationException("browser path is empty");
        }
    }

    public void writeExternal(@Nullable Element element) {
        super.writeExternal(element);
        if (element == null) {
            return;
        }
        CharSequence charSequence = this.workingDirectory;
        if (!(charSequence.length() == 0)) {
            JDOMExternalizerUtil.addElementWithValueAttribute((Element)element, (String)ReactNativeRunConfigurationKt.access$getWORKING_DIR_TAG$p(), (String)this.workingDirectory);
        }
        JDOMExternalizerUtil.addElementWithValueAttribute((Element)element, (String)ReactNativeRunConfigurationKt.access$getNODE_INTERPRETER_TAG$p(), (String)this.nodePath.getReferenceName());
        if (this.reactNativePackage != null) {
            NodePackage nodePackage = this.reactNativePackage;
            JDOMExternalizerUtil.addElementWithValueAttribute((Element)element, (String)ReactNativeRunConfigurationKt.access$getREACT_NATIVE_TAG$p(), (String)(nodePackage != null ? nodePackage.getSystemIndependentPath() : null));
        }
        JDOMExternalizerUtil.addElementWithValueAttribute((Element)element, (String)ReactNativeRunConfigurationKt.access$getPLATFORM_TAG$p(), (String)this.platform.name());
        charSequence = this.runArguments;
        if (!(charSequence.length() == 0)) {
            JDOMExternalizerUtil.addElementWithValueAttribute((Element)element, (String)ReactNativeRunConfigurationKt.access$getRUN_ARGUMENTS_TAG$p(), (String)this.runArguments);
        }
        this.envData.writeExternal(element);
        if (this.onlyStartPackager) {
            JDOMExternalizerUtil.addElementWithValueAttribute((Element)element, (String)ReactNativeRunConfigurationKt.access$getONLY_START_PACKAGER$p(), (String)String.valueOf(Boolean.TRUE));
        }
        if (this.browserId != null) {
            JDOMExternalizerUtil.addElementWithValueAttribute((Element)element, (String)ReactNativeRunConfigurationKt.access$getBROWSER_TAG$p(), (String)this.browserId);
        }
    }

    public void readExternal(@Nullable Element element) {
        String runArguments;
        String platformTag;
        String reactNativeTag;
        String interpreterRefName;
        super.readExternal(element);
        if (element == null) {
            return;
        }
        String workingDir = JDOMExternalizerUtil.getFirstChildValueAttribute((Element)element, (String)ReactNativeRunConfigurationKt.access$getWORKING_DIR_TAG$p());
        if (workingDir != null) {
            this.workingDirectory = workingDir;
        }
        if ((interpreterRefName = JDOMExternalizerUtil.getFirstChildValueAttribute((Element)element, (String)ReactNativeRunConfigurationKt.access$getNODE_INTERPRETER_TAG$p())) != null) {
            NodeJsInterpreterRef nodeJsInterpreterRef = NodeJsInterpreterRef.create((String)interpreterRefName);
            Intrinsics.checkExpressionValueIsNotNull((Object)nodeJsInterpreterRef, (String)"NodeJsInterpreterRef.create(interpreterRefName)");
            this.nodePath = nodeJsInterpreterRef;
        }
        if ((reactNativeTag = JDOMExternalizerUtil.getFirstChildValueAttribute((Element)element, (String)ReactNativeRunConfigurationKt.access$getREACT_NATIVE_TAG$p())) != null) {
            this.reactNativePackage = new NodePackage(reactNativeTag);
        }
        if ((platformTag = JDOMExternalizerUtil.getFirstChildValueAttribute((Element)element, (String)ReactNativeRunConfigurationKt.access$getPLATFORM_TAG$p())) != null) {
            this.platform = ReactNativePlatform.valueOf(platformTag);
        }
        if ((runArguments = JDOMExternalizerUtil.getFirstChildValueAttribute((Element)element, (String)ReactNativeRunConfigurationKt.access$getRUN_ARGUMENTS_TAG$p())) != null) {
            this.runArguments = runArguments;
        }
        EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.readExternal((Element)element);
        Intrinsics.checkExpressionValueIsNotNull((Object)environmentVariablesData, (String)"EnvironmentVariablesData.readExternal(element)");
        this.envData = environmentVariablesData;
        String onlyStartPackager = JDOMExternalizerUtil.getFirstChildValueAttribute((Element)element, (String)ReactNativeRunConfigurationKt.access$getONLY_START_PACKAGER$p());
        Boolean bl = Boolean.valueOf(onlyStartPackager);
        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"valueOf(onlyStartPackager)");
        this.onlyStartPackager = bl;
        this.browserId = JDOMExternalizerUtil.getFirstChildValueAttribute((Element)element, (String)ReactNativeRunConfigurationKt.access$getBROWSER_TAG$p());
    }

    @Nullable
    public final WebBrowser getBrowser() {
        return WebBrowserManager.getInstance().findBrowserById(this.browserId);
    }

    public ReactNativeRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        super(project, factory, "");
        NodeJsInterpreterRef nodeJsInterpreterRef = NodeJsInterpreterRef.createProjectRef();
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeJsInterpreterRef, (String)"NodeJsInterpreterRef.createProjectRef()");
        this.nodePath = nodeJsInterpreterRef;
        this.workingDirectory = "";
        this.platform = ReactNativePlatform.ANDROID;
        this.runArguments = "";
        EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.DEFAULT;
        Intrinsics.checkExpressionValueIsNotNull((Object)environmentVariablesData, (String)"EnvironmentVariablesData.DEFAULT");
        this.envData = environmentVariablesData;
    }
}

