/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.UtilKt;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.AsyncValueLoader;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.ExceptionData;
import org.jetbrains.debugger.SuspendContextBase;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.WipAsyncCallFrame;
import org.jetbrains.wip.WipBreakpoint;
import org.jetbrains.wip.WipCallFrame;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipExceptionData;
import org.jetbrains.wip.WipReaderService;
import org.jetbrains.wip.WipSuspendContext;
import org.jetbrains.wip.WipValueManager;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.WipProtocolReader;
import org.jetbrains.wip.protocol.debugger.LocationValue;
import org.jetbrains.wip.protocol.debugger.PausedEventData;
import org.jetbrains.wip.protocol.debugger.ScopeValue;
import org.jetbrains.wip.protocol.runtime.CallFrameValue;
import org.jetbrains.wip.protocol.runtime.RuntimeKt;
import org.jetbrains.wip.protocol.runtime.StackTraceValue;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000w\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001!\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\n\u00104\u001a\u0006\u0012\u0002\b\u00030\u001cJ\u001e\u00105\u001a\u0002062\f\u00107\u001a\b\u0012\u0004\u0012\u0002080\u00112\b\u00109\u001a\u0004\u0018\u00010:R\u001c\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u001c\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR \u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u000b0\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0010\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\"R\u0014\u0010#\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0016\u0010&\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010)\u001a\u0004\u0018\u00010\u00022\b\u0010(\u001a\u0004\u0018\u00010\u00028\u0016@RX\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u0014\u0010.\u001a\u00020/X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103\u00a8\u0006;"}, d2={"Lorg/jetbrains/wip/WipSuspendContext;", "Lorg/jetbrains/debugger/SuspendContextBase;", "Lorg/jetbrains/wip/WipCallFrame;", "vm", "Lorg/jetbrains/wip/WipVm;", "data", "Lorg/jetbrains/wip/protocol/debugger/PausedEventData;", "explicitPaused", "", "(Lorg/jetbrains/wip/WipVm;Lorg/jetbrains/wip/protocol/debugger/PausedEventData;Z)V", "_asyncFrames", "", "Lorg/jetbrains/wip/WipAsyncCallFrame;", "[Lorg/jetbrains/wip/WipAsyncCallFrame;", "_frames", "[Lorg/jetbrains/wip/WipCallFrame;", "breakpointsHit", "", "Lorg/jetbrains/debugger/Breakpoint;", "getBreakpointsHit", "()Ljava/util/List;", "exceptionData", "Lorg/jetbrains/debugger/ExceptionData;", "getExceptionData", "()Lorg/jetbrains/debugger/ExceptionData;", "setExceptionData", "(Lorg/jetbrains/debugger/ExceptionData;)V", "frames", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/debugger/CallFrame;", "getFrames", "()Lorg/jetbrains/concurrency/Promise;", "framesLoader", "org/jetbrains/wip/WipSuspendContext$framesLoader$1", "Lorg/jetbrains/wip/WipSuspendContext$framesLoader$1;", "hasUnresolvedBreakpointsHit", "getHasUnresolvedBreakpointsHit", "()Z", "hitBreakpoints", "", "value", "topFrame", "getTopFrame", "()Lorg/jetbrains/wip/WipCallFrame;", "setTopFrame", "(Lorg/jetbrains/wip/WipCallFrame;)V", "valueManager", "Lorg/jetbrains/wip/WipValueManager;", "getValueManager", "()Lorg/jetbrains/wip/WipValueManager;", "getVm", "()Lorg/jetbrains/wip/WipVm;", "reloadFrames", "setFrames", "", "frameDataList", "Lorg/jetbrains/wip/protocol/debugger/CallFrameValue;", "asyncFrameDataList", "Lorg/jetbrains/wip/protocol/runtime/StackTraceValue;", "wip-backend"})
public final class WipSuspendContext
extends SuspendContextBase<WipCallFrame> {
    @NotNull
    private final WipValueManager valueManager;
    private final List<String> hitBreakpoints;
    @Nullable
    private volatile WipCallFrame topFrame;
    private volatile WipCallFrame[] _frames;
    private volatile WipAsyncCallFrame[] _asyncFrames;
    @Nullable
    private ExceptionData exceptionData;
    private final framesLoader.1 framesLoader;
    @NotNull
    private final WipVm vm;

    @NotNull
    public WipValueManager getValueManager() {
        return this.valueManager;
    }

    @Nullable
    public WipCallFrame getTopFrame() {
        return this.topFrame;
    }

    private void setTopFrame(WipCallFrame value) {
        this.topFrame = value;
    }

    @Nullable
    public ExceptionData getExceptionData() {
        return this.exceptionData;
    }

    public void setExceptionData(@Nullable ExceptionData exceptionData) {
        this.exceptionData = exceptionData;
    }

    @NotNull
    public Promise<CallFrame[]> getFrames() {
        Promise promise2 = this.framesLoader.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"framesLoader.get()");
        return promise2;
    }

    /*
     * WARNING - void declaration
     */
    public final void setFrames(@NotNull List<? extends org.jetbrains.wip.protocol.debugger.CallFrameValue> frameDataList, @Nullable StackTraceValue asyncFrameDataList) {
        void $receiver$iv;
        WipCallFrame[] frames;
        WipCallFrame wipCallFrame;
        Object object;
        Intrinsics.checkParameterIsNotNull(frameDataList, (String)"frameDataList");
        int size$iv = frameDataList.size();
        Object[] result$iv = new WipCallFrame[size$iv];
        int n = 0;
        int n2 = size$iv - 1;
        if (n <= n2) {
            void i$iv;
            do {
                void it;
                void var8_17 = ++i$iv;
                void var16_13 = i$iv;
                object = result$iv;
                object[var16_13] = wipCallFrame = new WipCallFrame(this.getValueManager(), frameDataList.get((int)it));
            } while (i$iv != n2);
        }
        if (!((result$iv = (size$iv = (Object[])(frames = result$iv))).length == 0)) {
            this.setTopFrame(frames[0]);
        }
        this._frames = frames;
        List asyncFrames = new ArrayList();
        for (StackTraceValue currentStackTrace = asyncFrameDataList; currentStackTrace != null; currentStackTrace = currentStackTrace.getParent()) {
            String description = currentStackTrace.getDescription();
            Iterable $receiver$iv2 = currentStackTrace.callFrames();
            int index$iv = 0;
            for (Object item$iv : $receiver$iv2) {
                void callFrameValue;
                int n3 = index$iv++;
                CallFrameValue callFrameValue2 = (CallFrameValue)item$iv;
                int i = n3;
                asyncFrames.add(new WipAsyncCallFrame((CallFrameValue)callFrameValue, i == 0 ? description : null));
            }
        }
        Collection description = asyncFrames;
        object = this;
        void thisCollection$iv = $receiver$iv;
        WipAsyncCallFrame[] wipAsyncCallFrameArray = thisCollection$iv.toArray(new WipAsyncCallFrame[thisCollection$iv.size()]);
        if (wipAsyncCallFrameArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        WipAsyncCallFrame[] wipAsyncCallFrameArray2 = wipAsyncCallFrameArray;
        object._asyncFrames = wipAsyncCallFrameArray2;
        int size$iv2 = ((Object[])frames).length + asyncFrames.size();
        CallFrame[] result$iv2 = new CallFrame[size$iv2];
        int n4 = 0;
        int n5 = size$iv2 - 1;
        if (n4 <= n5) {
            void i$iv;
            do {
                void it;
                void callFrameValue = ++i$iv;
                void var16_15 = i$iv;
                object = result$iv2;
                object[var16_15] = wipCallFrame = it < ((Object[])frames).length ? (CallFrame)frames[it] : (CallFrame)asyncFrames.get((int)(it - ((Object[])frames).length));
            } while (i$iv != n5);
        }
        CallFrame[] result = result$iv2;
        this.framesLoader.set(result);
    }

    public boolean getHasUnresolvedBreakpointsHit() {
        if (UtilKt.isNullOrEmpty((Collection)this.hitBreakpoints)) {
            return false;
        }
        THashSet hitVmBreakpoints = new THashSet((Collection)this.hitBreakpoints);
        for (WipBreakpoint breakpoint : this.getValueManager().getVm().getBreakpointManager().getBreakpoints()) {
            hitVmBreakpoints.remove((Object)breakpoint.getVmId());
        }
        Collection collection = (Collection)hitVmBreakpoints;
        return !collection.isEmpty();
    }

    @NotNull
    public List<Breakpoint> getBreakpointsHit() {
        Set breakpoints = this.getValueManager().getVm().getBreakpointManager().getBreakpoints();
        if (this.hitBreakpoints != null) {
            SmartList result = new SmartList();
            for (WipBreakpoint breakpoint : breakpoints) {
                String vmId = breakpoint.getVmId();
                if (vmId == null || !this.hitBreakpoints.contains(vmId)) continue;
                result.add((Object)breakpoint);
            }
            return (List)result;
        }
        WipCallFrame wipCallFrame = this.getTopFrame();
        if (wipCallFrame == null) {
            return CollectionsKt.emptyList();
        }
        WipCallFrame topFrame = wipCallFrame;
        int line = topFrame.getLine();
        int column = topFrame.getColumn();
        List result = null;
        block1: for (WipBreakpoint breakpoint : breakpoints) {
            for (LocationValue actualLocation : breakpoint.getActualLocations()) {
                int actualColumnNumber = actualLocation.getColumnNumber();
                if (!Intrinsics.areEqual((Object)actualLocation.scriptId(), (Object)topFrame.getScriptId()) || actualLocation.getLineNumber() != line || actualColumnNumber != column && actualColumnNumber > 0) continue;
                if (result == null) {
                    result = (List)new SmartList();
                }
                WipBreakpoint wipBreakpoint = breakpoint;
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)wipBreakpoint), (String)"breakpoint");
                result.add(wipBreakpoint);
                continue block1;
            }
        }
        List list = result;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final Promise<?> reloadFrames() {
        this.framesLoader.markDirty();
        SmartList promises = new SmartList();
        if (this._frames == null) {
            Intrinsics.throwNpe();
        }
        WipCallFrame[] wipCallFrameArray = this._frames;
        for (int i = 0; i < wipCallFrameArray.length; ++i) {
            WipCallFrame frame = wipCallFrameArray[i];
            for (ScopeValue scopeValue : frame.getScopesData()) {
                WipCommandProcessor wipCommandProcessor = this.getValueManager().getCommandProcessor();
                String string = scopeValue.object().getObjectId();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                promises.add((Object)wipCommandProcessor.send((Request)RuntimeKt.ReleaseObject(string)));
            }
        }
        promises.add((Object)this.framesLoader.get());
        Promise $receiver$iv = Promises.all((Collection)((Collection)promises));
        Promise promise2 = $receiver$iv.then(new Function<Unit, SUB_RESULT>(this){
            final /* synthetic */ WipSuspendContext this$0;
            {
                this.this$0 = wipSuspendContext;
            }

            public final Unit fun(Object it) {
                this.this$0.getValueManager().clearCaches();
                return Unit.INSTANCE;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"(this as Promise<Any?>).then({ handler() })");
        return promise2;
    }

    @NotNull
    public WipVm getVm() {
        return this.vm;
    }

    public WipSuspendContext(@NotNull WipVm vm, @NotNull PausedEventData data, boolean explicitPaused) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)vm), (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        super(explicitPaused);
        this.vm = vm;
        this.valueManager = new WipValueManager(this.getVm(), null);
        this.framesLoader = new AsyncValueLoader<CallFrame[]>(this){
            final /* synthetic */ WipSuspendContext this$0;

            @NotNull
            protected Promise<CallFrame[]> load(@NotNull AsyncPromise<CallFrame[]> result) {
                Intrinsics.checkParameterIsNotNull(result, (String)"result");
                WipCallFrame[] wipCallFrameArray = WipSuspendContext.access$get_frames$p(this.this$0);
                if (wipCallFrameArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<org.jetbrains.debugger.CallFrame>");
                }
                WipAsyncCallFrame[] wipAsyncCallFrameArray = WipSuspendContext.access$get_asyncFrames$p(this.this$0);
                if (wipAsyncCallFrameArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<org.jetbrains.debugger.CallFrame>");
                }
                return Promises.resolvedPromise((Object)ArraysKt.plus((Object[])wipCallFrameArray, (Object[])wipAsyncCallFrameArray));
            }
            {
                this.this$0 = $outer;
            }
        };
        PausedEventData.Data additionalData = data.getData();
        if (data.reason() == PausedEventData.Reason.EXCEPTION && additionalData != null) {
            WipValueManager wipValueManager = this.getValueManager();
            WipProtocolReader wipProtocolReader = WipReaderService.get();
            JsonReaderEx jsonReaderEx = additionalData.getDeferredReader();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonReaderEx, (String)"additionalData.deferredReader");
            this.setExceptionData(new WipExceptionData(wipValueManager.createValue(wipProtocolReader.parseRemoteObjectValue(jsonReaderEx))));
        } else {
            this.setExceptionData(null);
        }
        List<org.jetbrains.wip.protocol.debugger.CallFrameValue> callFrames = data.callFrames();
        StackTraceValue asyncStackTrace = this.getVm().getCaptureAsyncStackTraces() ? data.getAsyncStackTrace() : null;
        this.setFrames(callFrames, asyncStackTrace);
        this.hitBreakpoints = data.getHitBreakpoints();
    }

    @Nullable
    public static final /* synthetic */ WipCallFrame[] access$get_frames$p(WipSuspendContext $this) {
        return $this._frames;
    }

    public static final /* synthetic */ void access$set_frames$p(WipSuspendContext $this, @Nullable WipCallFrame[] wipCallFrameArray) {
        $this._frames = wipCallFrameArray;
    }

    @Nullable
    public static final /* synthetic */ WipAsyncCallFrame[] access$get_asyncFrames$p(WipSuspendContext $this) {
        return $this._asyncFrames;
    }

    public static final /* synthetic */ void access$set_asyncFrames$p(WipSuspendContext $this, @Nullable WipAsyncCallFrame[] wipAsyncCallFrameArray) {
        $this._asyncFrames = wipAsyncCallFrameArray;
    }
}

